from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


extract_header = _Mock()

os = _Mock()

py3compat = _Mock()

threading = _Mock()

time = _Mock()

uuid = _Mock()

warn = _Mock()

zmq = _Mock()

CHILD = 1

MASTER = 0

class IOLoop(_Mock):
  pass
  ERROR = 24
  NONE = 0
  READ = 1
  WRITE = 4
  _EPOLLERR = 8
  _EPOLLET = 2147483648
  _EPOLLHUP = 16
  _EPOLLIN = 1
  _EPOLLONESHOT = 1073741824
  _EPOLLOUT = 4
  _EPOLLPRI = 2
  _EPOLLRDHUP = 8192

class OutStream(_Mock):
  pass
  _subprocess_flush_limit = 256
  flush_interval = 0.05

class StringIO(_Mock):
  pass


class UnsupportedOperation(_Mock):
  pass


class unicode_type(_Mock):
  pass


