from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


IPython = _Mock()

PyColorize = _Mock()

abc = _Mock()

absolute_import = _Mock()

ask_yes_no = _Mock()

ast = _Mock()

atexit = _Mock()

available_events = _Mock()

builtin_mod = _Mock()

check_linecache_ipython = _Mock()

debugger = _Mock()

dedent_re = _Mock()

error = _Mock()

format_screen = _Mock()

functools = _Mock()

get_default_colors = _Mock()

get_home_dir = _Mock()

get_ipython_dir = _Mock()

get_py_filename = _Mock()

getoutput = _Mock()

io = _Mock()

io_open = _Mock()

iteritems = _Mock()

magic = _Mock()

no_op = _Mock()

no_op_context = _Mock()

oinspect = _Mock()

openpy = _Mock()

os = _Mock()

page = _Mock()

prefilter = _Mock()

print_function = _Mock()

py3compat = _Mock()

re = _Mock()

runpy = _Mock()

shadowns = _Mock()

skip_doctest = _Mock()

softspace = _Mock()

string_types = _Mock()

subprocess = _Mock()

sys = _Mock()

system = _Mock()

tempfile = _Mock()

types = _Mock()

ultratb = _Mock()

undoc = _Mock()

unquote_filename = _Mock()

warn = _Mock()

with_metaclass = _Mock()

ESC_MAGIC = '%'

ESC_MAGIC2 = '%%'

class AliasError(_Mock):
  pass


class AliasManager(_Mock):
  pass


class BuiltinTrap(_Mock):
  pass


class Bunch(_Mock):
  pass


class CBool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CachingCompiler(_Mock):
  pass


class CaselessStrEnum(_Mock):
  pass
  info_text = 'any value'

class DisplayFormatter(_Mock):
  pass


class DisplayHook(_Mock):
  pass


class DisplayPublisher(_Mock):
  pass


class DisplayTrap(_Mock):
  pass


class DollarFormatter(_Mock):
  pass
  skip_doctest = False

class DummyMod(_Mock):
  pass


class Enum(_Mock):
  pass
  info_text = 'any value'

class EventManager(_Mock):
  pass


class ExitAutocall(_Mock):
  pass
  rewrite = False

class ExtensionManager(_Mock):
  pass


class HistoryManager(_Mock):
  pass


class IPythonInputSplitter(_Mock):
  pass
  _full_dedent = False
  encoding = ''
  indent_spaces = 0
  source = ''
  source_raw = ''
  transformer_accumulating = False
  within_python_line = False

class Instance(_Mock):
  pass
  info_text = 'any value'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class InteractiveShell(_Mock):
  pass
  default_user_namespaces = True

class InteractiveShellABC(_Mock):
  pass
  _abc_negative_cache_version = 43

class LSString(_Mock):
  pass


class LaTeXTool(_Mock):
  pass


class List(_Mock):
  pass
  info_text = 'any value'

class Logger(_Mock):
  pass


class Macro(_Mock):
  pass


class NoOpContext(_Mock):
  pass


class PayloadManager(_Mock):
  pass


class PickleShareDB(_Mock):
  pass
  _abc_negative_cache_version = 48

class PrefilterManager(_Mock):
  pass


class ProfileDir(_Mock):
  pass


class PromptManager(_Mock):
  pass


class ReadlineNoRecord(_Mock):
  pass


class SList(_Mock):
  pass


class SeparateUnicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class SingletonConfigurable(_Mock):
  pass


class SpaceInInput(_Mock):
  pass


class StrDispatch(_Mock):
  pass


class Struct(_Mock):
  pass
  _allownew = True

class Type(_Mock):
  pass
  info_text = 'any value'

class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class UsageError(_Mock):
  pass


class prepended_to_syspath(_Mock):
  pass


class unicode_type(_Mock):
  pass


