from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


SIGNAL = _Mock()

_ = _Mock()

create_action = _Mock()

getcwd = _Mock()



class FindInFiles(_Mock):
  pass
  ALLOWED_AREAS = 15
  CONF_SECTION = 'find_in_files'
  DISABLE_ACTIONS_WHEN_HIDDEN = True
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  LOCATION = 1
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class FindInFilesWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QApplication(_Mock):
  pass
  CodecForTr = 0
  CustomColor = 1
  DefaultCodec = 0
  GuiClient = 1
  GuiServer = 2
  ManyColor = 2
  NormalColor = 0
  Tty = 0
  UnicodeUTF8 = 1

class Signal(_Mock):
  pass


class SpyderPluginMixin(_Mock):
  pass
  ALLOWED_AREAS = 15
  DISABLE_ACTIONS_WHEN_HIDDEN = True
  LOCATION = 1

