/*	############################################################
	# @(#) chr_dos.h
	# @(#)
	# @(#) Copyright (c) 1995-2001 by Dirk Hagedorn
	# @(#) Dirk Hagedorn (udo@dirk-hagedorn.de)
	#
	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.
	# 
	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.
	# 
	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	# 
	# @(#) Uebersetzungstabellen fuer MS-DOS
	############################################################	*/

#include	"portab.h"

#ifndef ID_CHARSET_H
#define	ID_CHARSET_H
const char *id_charset_h= "@(#) chr_dos.h   07.12.1997";
#endif

#ifndef	THIS_CHARSET
#define	THIS_CHARSET	"DOS"
#endif


/*	------------------------------------------------------------	*/

/*	############################################################
	# ISO-Zeichensatz in System-Zeichensatz umsetzen
	############################################################	*/
typedef struct _iso2sys
{	unsigned char	iso;
	unsigned char	sys;
}	ISO2SYS;


LOCAL const ISO2SYS iso2sys_item[128]=
{
	{ 128,	0		},		/* null		*/	/* !!!! */
	{ 129,	0		},		/* null		*/	/* !!!! */
	{ 130,	0		},		/* '' (9u)	*/	/* !!!! */
	{ 131,	'\237'	},		/* #f		*/
	{ 132,	0		},		/* "" (99u)	*/	/* !!!! */
	{ 133,	0		},		/* !..		*/	/* !!!! */
	{ 134,	'\273'	},		/* #dag		*/
	{ 135,	0		},		/* 2x#dag	*/	/* !!!! */
	{ 136,	'\336'	},		/* #circ	*/
	{ 137,	0		},		/* #promill	*/
	{ 138,	'S'		},		/* vS		*/	/* !!!! */
	{ 139,	'<'		},		/* <		*/	/* !!!! */
	{ 140,	'\265'	},		/* &OE		*/
	{ 141,	0		},		/* null		*/
	{ 142,	0		},		/* null		*/
	{ 143,	0		},		/* null		*/
	{ 144,	0		},		/* null		*/
	{ 145,	0		},		/* '' (6o)	*/	/* !!!! */
	{ 146,	0		},		/* '' (9o)	*/	/* !!!! */
	{ 147,	0		},		/* "" (66o)	*/	/* !!!! */
	{ 148,	0		},		/* "" (99u)	*/	/* !!!! */
	{ 149,	'\371'	},		/* #bullet	*/
	{ 150,	'-'		},		/* --		*/	/* !!!! */
	{ 151,	'-'		},		/* ---		*/	/* !!!! */
	{ 152,	'~'		},		/* !~		*/	/* !!!! */
	{ 153,	'\277'	},		/* #tm		*/
	{ 154,	's'		},		/* vs		*/
	{ 155,	'>'		},		/* >		*/
	{ 156,	'\264'	},		/* &oe		*/
	{ 157,	0		},		/* null		*/
	{ 158,	0		},		/* null		*/
	{ 159,	'Y'		},		/* "Y		*/	/* !!!! */
	{ 150,	0		},		/* null		*/
	{ 161,	'\255'	},		/* #!		*/
	{ 162,	'\233'	},		/* #cent	*/
	{ 163,	'\234'	},		/* #pound	*/
	{ 164,	0		},		/* general currency	*/
	{ 165,	'\235'	},		/* #yen		*/
	{ 166,	'|'		},		/* broken dash	*/	/* !!!! */
	{ 167,	'\335'	},		/* #sect	*/
	{ 168,	'\271'	},		/* #"		*/
	{ 169,	'\275'	},		/* #copy	*/
	{ 170,	'\246'	},		/* _a		*/
	{ 171,	'\256'	},		/* #<		*/
	{ 172,	'\252'	},		/* #neg		*/
	{ 173,	0		},		/* strich	*/	/* !!!! */
	{ 174,	'\276'	},		/* #reg		*/
	{ 175,	0		},		/* #macron	*/	/* !!!! */
	{ 176,	'\370'	},		/* #degree	*/
	{ 177,	'\361'	},		/* #pm		*/
	{ 178,	'\375'	},		/* #^2		*/
	{ 179,	'\376'	},		/* #^3		*/
	{ 180,	'\272'	},		/* #'		*/
	{ 181,	'\346'	},		/* #mu		*/
	{ 182,	'\274'	},		/* #p		*/
	{ 183,	'\372'	},		/* #cdot	*/
	{ 184,	0		},		/* cedille	*/	/* !!!! */
	{ 185,	0		},		/* #^1		*/	/* !!!! */
	{ 186,	'\247'	},		/* _o		*/
	{ 187,	'\257'	},		/* #>		*/
	{ 188,	'\254'	},		/* #1/4		*/
	{ 189,	'\253'	},		/* #1/2		*/
	{ 190,	0		},		/* #3/4		*/	/* !!!! */
	{ 191,	'\250'	},		/* #?		*/
	{ 192,	'\266'	},		/* `A		*/
	{ 193,	'A'		},		/* 'A		*/	/* !!!! */
	{ 194,	'A'		},		/* ^A		*/	/* !!!! */
	{ 195,	'\267'	},		/* ~A		*/
	{ 196,	'\216'	},		/* "A		*/
	{ 197,	'\217'	},		/* .A		*/
	{ 198,	'\222'	},		/* &AE		*/
	{ 199,	'\200'	},		/* ,C		*/
	{ 200,	'E'		},		/* `E		*/	/* !!!! */
	{ 201,	'E'		},		/* 'E		*/	/* !!!! */
	{ 202,	'E'		},		/* ^E		*/	/* !!!! */
	{ 203,	'E'		},		/* "E		*/	/* !!!! */
	{ 204,	'I'		},		/* `I		*/	/* !!!! */
	{ 205,	'I'		},		/* 'I		*/	/* !!!! */
	{ 206,	'I'		},		/* ^I		*/	/* !!!! */
	{ 207,	'I'		},		/* "I		*/	/* !!!! */
	{ 208,	0		},		/* -D		*/
	{ 209,	'\245'	},		/* ~N		*/
	{ 210,	'O'		},		/* `O		*/	/* !!!! */
	{ 211,	'O'		},		/* 'O		*/	/* !!!! */
	{ 212,	'O'		},		/* ^O		*/	/* !!!! */
	{ 213,	'\270'	},		/* ~O		*/
	{ 214,	'\231'	},		/* "O		*/
	{ 215,	'x'		},		/* #times	*/	/* !!!! */
	{ 216,	'\262'	},		/* /O		*/
	{ 217,	'U'		},		/* `U		*/	/* !!!! */
	{ 218,	'U'		},		/* 'U		*/	/* !!!! */
	{ 219,	'U'		},		/* ^U		*/	/* !!!! */
	{ 220,	'\232'	},		/* "U		*/
	{ 221,	'Y'		},		/* 'Y		*/	/* !!!! */
	{ 222,	0		},		/* |b		*/
	{ 223,	'\341'	},		/* "s (beta) */
	{ 224,	'\205'	},		/* `a		*/
	{ 225,	'\240'	},		/* 'a		*/
	{ 226,	'\203'	},		/* ^a		*/
	{ 227,	'\260'	},		/* ~a		*/
	{ 228,	'\204'	},		/* "a		*/
	{ 229,	'\206'	},		/* .a		*/
	{ 230,	'\221'	},		/* &ae		*/
	{ 231,	'\207'	},		/* ,c		*/
	{ 232,	'\212'	},		/* `e		*/
	{ 233,	'\202'	},		/* 'e		*/
	{ 234,	'\210'	},		/* ^e		*/
	{ 235,	'\211'	},		/* "e		*/
	{ 236,	'\215'	},		/* `i		*/
	{ 237,	'\241'	},		/* 'i		*/
	{ 238,	'\214'	},		/* ^i		*/
	{ 239,	'\213'	},		/* "i		*/
	{ 240,	0		},		/* o|''		*/	/* !!!! */
	{ 241,	'\244'	},		/* ~n		*/
	{ 242,	'\225'	},		/* `o		*/
	{ 243,	'\242'	},		/* 'o		*/
	{ 244,	'\223'	},		/* ^o		*/
	{ 245,	'\261'	},		/* ~o		*/
	{ 246,	'\224'	},		/* "o		*/
	{ 247,	'\336'	},		/* #div		*/
	{ 248,	'\263'	},		/* /o		*/
	{ 249,	'\227'	},		/* `u		*/
	{ 250,	'\243'	},		/* 'u		*/
	{ 251,	'\226'	},		/* ^u		*/
	{ 252,	'\201'	},		/* "u		*/
	{ 253,	'y'		},		/* 'y		*/	/* !!!! */
	{ 254,	0		},		/* |B		*/	/* !!!! */
	{ 255,	'\230'	}		/* "y		*/
};

/*	------------------------------------------------------------	*/

/*	############################################################
	# Systemzeichensatz in andere Zeichensaetze umwandeln
	############################################################	*/

typedef struct _chartable
{
	unsigned char system;
	char ascii[16];
	char ansi[16];
	char tex[16];
	char html[10];
}	CHARTABLE;

LOCAL /* const */ CHARTABLE chrtab[128]=
{
	{	'\200',	"C",	"\\'C7",		"\\c{C}",			"&Ccedil;"	},
	{	'\201',	"ue",	"\\'FC",		"{\\\"u}",			"&uuml;"	},
	{	'\202',	"e",	"\\'E9",		"\\'{e}",			"&eacute;"	},
	{	'\203',	"a",	"\\'E2",		"\\^{a}",			"&acirc;"	},
	{	'\204',	"ae",	"\\'E4",		"{\\\"a}",			"&auml;"	},
	{	'\205',	"a",	"\\'E0",		"\\`{a}",			"&agrave;"	},
	{	'\206',	"a",	"\\'E5",		"{\\aa}",			"&aring;"	},
	{	'\207',	"c",	"\\'E7",		"\\c{c}",			"&ccedil;"	},

	{	'\210',	"e",	"\\'EA",		"\\^{e}",			"&ecirc;"	},
	{	'\211',	"e",	"\\'EB",		"\\\"{e}",			"&euml;"	},
	{	'\212',	"e",	"\\'E8",		"\\`{e}",			"&egrave;"	},
	{	'\213',	"i",	"\\'EF",		"\\\"{i}",			"&iuml;"	},
	{	'\214',	"i",	"\\'EE",		"\\^{i}",			"&icirc;"	},
	{	'\215',	"i",	"\\'EC",		"\\`{i}",			"&igrave;"	},
	{	'\216',	"Ae",	"\\'C4",		"{\\\"A}",			"&Auml;"	},
	{	'\217',	"A",	"\\'C5",		"{\\AA}",			"&Aring;"	},

	{	'\220',	"E",	"\\'C9",		"\\'{E}",			"&Eacute;"	},
	{	'\221',	"ae",	"\\'E6",		"{\\ae}",			"&aelig;"	},
	{	'\222',	"AE",	"\\'C6",		"{\\AE}",			"&AElig;"	},
	{	'\223',	"o",	"\\'F4",		"\\^{o}",			"&ocirc;"	},
	{	'\224',	"oe",	"\\'F6",		"{\\\"o}",			"&ouml;"	},
	{	'\225',	"o",	"\\'F2",		"\\`{o}",			"&ograve;"	},
	{	'\226',	"u",	"\\'FB",		"\\^{u}",			"&ucirc;"	},
	{	'\227',	"u",	"\\'F9",		"\\`{u}",			"&ugrave;"	},

	{	'\230',	"y",	"\\'FF",		"\\\"{y}",			"&yuml;"	},
	{	'\231',	"Oe",	"\\'D6",		"{\\\"O}",			"&Ouml;"	},
	{	'\232',	"Ue",	"\\'DC",		"{\\\"U}",			"&Uuml;"	},
	{	'\233',	"",		"\\'A2",		"cent",				"&#162;"	},
	{	'\234',	"",		"\\'A3",		"\\pounds{}",		"&#163;"	},
	{	'\235',	"",		"\\'A5",		"yen",				"&#165;"	},
	{	'\236',	"ss",	"\\'DF",		"{\\ss}",			"&szlig;"	},
	{	'\237',	"",		"\\'83",		"$f$",				"&#166;"	},

	{	'\240',	"a",	"\\'E1",		"\\'{a}",			"&aacute;"	},
	{	'\241',	"i",	"\\'ED",		"\\'{i}",			"&iacute;"	},
	{	'\242',	"o",	"\\'F3",		"\\'{o}",			"&oacute;"	},
	{	'\243',	"u",	"\\'FA",		"\\'{u}",			"&uacute;"	},
	{	'\244',	"n",	"\\'F1",		"\\~{n}",			"&ntilde;"	},
	{	'\245',	"N",	"\\'D1",		"\\~{N}",			"&Ntilde;"	},
	{	'\246',	"",		"\\'AA",		"\\b{a}",			"&#170;"	},
	{	'\247',	"",		"\\'BA",		"\\b{o}",			"&#186;"	},

	{	'\250',	"",		"\\'BF",		"?`",				"&#191;"	},
	{	'\251',	"",		"",				"",					""			},
	{	'\252',	"",		"\\'AC",		"$\\neg$",			"&#172;"	},
	{	'\253',	"",		"\\'BD",		"$\\frac{1}{2}$",	"&#189;"	},
	{	'\254',	"",		"\\'BC",		"$\\frac{1}{4}$",	"&#188;"	},
	{	'\255',	"!",	"\\'A1",		"!`",				"&#161;"	},
	{	'\256',	"",		"\\'AB",		"\"<",				"&#171;"	},
	{	'\257',	"",		"\\'BB",		"\">",				"&#187;"	},

	{	'\260',	"a",	"\\'E3",		"\\~{a}",			"&atilde;"	},
	{	'\261',	"o",	"\\'F5",		"\\~{o}",			"&otilde;"	},
	{	'\262',	"O",	"\\'D8",		"{\\O}",			"&Oslash;"	},
	{	'\263',	"|",	"|",			"$\\mid$",			"|"			},
	{	'\264',	"+",	"+",			"+",				"+"			},
	{	'\265',	"+",	"+",			"+",				"+"			},
	{	'\266',	"+",	"+",			"+",				"+"			},
	{	'\267',	"+",	"+",			"+",				"+"			},

	{	'\270',	"+",	"+",			"+",				"+"			},
	{	'\271',	"+",	"+",			"+",				"+"			},
	{	'\272',	"|",	"|",			"$\\mid$",			"|"			},
	{	'\273',	"+",	"+",			"+",				"+"			},
	{	'\274',	"+",	"+",			"+",				"+"			},
	{	'\275',	"+",	"+",			"+",				"+"			},
	{	'\276',	"+",	"+",			"+",				"+"			},
	{	'\277',	"+",	"+",			"+",				"+"			},

	{	'\300',	"+",	"+",			"+",				"+"			},
	{	'\301',	"+",	"+",			"+",				"+"			},
	{	'\302',	"+",	"+",			"+",				"+"			},
	{	'\303',	"+",	"+",			"+",				"+"			},
	{	'\304',	"-",	"-",			"-",				"-"			},
	{	'\305',	"+",	"+",			"+",				"+"			},
	{	'\306',	"+",	"+",			"+",				"+"			},
	{	'\307',	"+",	"+",			"+",				"+"			},

	{	'\310',	"+",	"+",			"+",				"+"			},
	{	'\311',	"+",	"+",			"+",				"+"			},
	{	'\312',	"+",	"+",			"+",				"+"			},
	{	'\313',	"+",	"+",			"+",				"+"			},
	{	'\314',	"+",	"+",			"+",				"+"			},
	{	'\315',	"-",	"-",			"-",				"-"			},
	{	'\316',	"+",	"+",			"+",				"+"			},
	{	'\317',	"+",	"+",			"+",				"+"			},

	{	'\320',	"+",	"+",			"+",				"+"			},
	{	'\321',	"+",	"+",			"+",				"+"			},
	{	'\322',	"+",	"+",			"+",				"+"			},
	{	'\323',	"+",	"+",			"+",				"+"			},
	{	'\324',	"+",	"+",			"+",				"+"			},
	{	'\325',	"+",	"+",			"+",				"+"			},
	{	'\326',	"+",	"+",			"+",				"+"			},
	{	'\327',	"+",	"+",			"+",				"+"			},

	{	'\330',	"+",	"+",			"+",				"+"			},
	{	'\331',	"+",	"+",			"+",				"+"			},
	{	'\332',	"+",	"+",			"+",				"+"			},
	{	'\333',	"",		"",				"",					""			},
	{	'\334',	"",		"",				"",					""			},
	{	'\335',	"|",	"|",			"$\\mid$",			"|"			},
	{	'\336',	"",		"\\'F7",		"$\\wedge$",		"&#136;"	},
	{	'\337',	"",		"{\\f2 \\'A5}",	"$\\infty$",		""			},

	{	'\340',	"",		"{\\f2 a}",		"$\\alpha$",		""			},
	{	'\341',	"ss",	"\\'DF",		"{\\ss}",			"&szlig;"	},
	{	'\342',	"",		"{\\f2 G}",		"$\\Gamma$",		""			},
	{	'\343',	"",		"{\\f2 p}",		"$\\pi$",			""			},
	{	'\344',	"",		"{\\f2 S}",		"$\\Sigma$",		""			},
	{	'\345',	"",		"{\\f2 s}",		"$\\sigma$",		""			},
	{	'\346',	"",		"\\'B5",		"$\\mu$",			"&#181;"	},
	{	'\347',	"",		"{\\f2 t}",		"$\\tau$",			""			},

	{	'\350',	"",		"{\\f2 F}",		"$\\Phi$",			""			},
	{	'\351',	"",		"{\\f2 f}",		"$\\phi$",			""			},
	{	'\352',	"",		"{\\f2 W}",		"$\\Omega$",		""			},
	{	'\353',	"",		"{\\f2 d}",		"$\\delta$",		""			},
	{	'\354',	"",		"{\\f2 \\'A5}",	"$\\infty$",		""			},
	{	'\355',	"o",	"\\'F8",		"\\/{o}",			"&#248;"	},
	{	'\356',	"",		"{\\f2 e}",		"$\\epsilon$",		""			},
	{	'\357',	"",		"{\\f2 h}",		"$\\eta$",			""			},

	{	'\360',	"",		"{\\f2 \\'BA}",	"$\\equiv$",		""			},
	{	'\361',	"",		"\\'B1",		"$\\pm$",			"&#177;"	},
	{	'\362',	"",		"{\\f2 \\'B3}",	"$\\geq$",			""			},
	{	'\363',	"",		"{\\f2 \\'A3}",	"$\\leq$",			""			},
	{	'\364',	"",		"",				"",					""			},
	{	'\365',	"",		"\\'A7",		"$\\div$",			"&#247;"	},
	{	'\366',	"",		"{\\f2 \\'B8}",	"$\\div$",			"&#247;"	},
	{	'\367',	"",		"{\\f2 \\'BB}",	"$\\approx$",		""			},

	{	'\370',	"",		"\\'B0",		"$\\circ$",			"&#176;"	},
	{	'\371',	"",		"\\'95",		"$\\bullet$",		"&#149;"	},
	{	'\372',	"",		"\\'B7",		"$\\bullet$",		"&#183;"	},
	{	'\373',	"",		"{\\f2 \\'D6}",	"$\\surd$",			""			},
	{	'\374',	"",		"",				"$^n$",				""			},
	{	'\375',	"",		"\\'B2",		"$^2$",				"&#178;"	},
	{	'\376',	"",		"\\'B3",		"$^3$",				"&#179;"	},
	{	'\377',	"",		"\\'AF",		"",					"&#175;"	}		/* #macron	*/
};

/*	------------------------------------------------------------	*/

/*	############################################################
	# universellen Zeichensatz in ASCII-Zeichensatz umsetzen
	############################################################	*/
typedef struct _uni2systab
{
	char			uni[8];
	unsigned char	system[2];
}	UNI2SYSTAB;

#define	UNI2SYSTABSIZE	64

LOCAL const UNI2SYSTAB uni2sys[UNI2SYSTABSIZE]=
{
	{	"(!\"a)",	"\204"	},
	{	"(!\"e)",	"\211"	},
	{	"(!\"i)",	"\213"	},
	{	"(!\"o)",	"\224"	},
	{	"(!\"u)",	"\201"	},
	{	"(!\"y)",	"\230"	},
	{	"(!\"s)",	"\341"	},
	{	"(!\"A)",	"\216"	},
	{	"(!\"E)",	"E"		},
	{	"(!\"I)",	"I"		},
	{	"(!\"O)",	"\231"	},
	{	"(!\"U)",	"\232"	},
	{	"(!\"Y)",	"Y"		},	/* 13 */

	{	"(!'a)",	"\240"	},
	{	"(!'e)",	"\202"	},
	{	"(!'i)",	"\241"	},
	{	"(!'o)",	"\242"	},
	{	"(!'u)",	"\243"	},
	{	"(!'y)",	"y"		},
	{	"(!'A)",	"A"		},
	{	"(!'E)",	"\220"	},
	{	"(!'I)",	"I"		},
	{	"(!'O)",	"O"		},
	{	"(!'U)",	"U"		},
	{	"(!'Y)",	"Y"		},	/* 12 */

	{	"(!`a)",	"\205"	},
	{	"(!`e)",	"\212"	},
	{	"(!`i)",	"\215"	},
	{	"(!`o)",	"\225"	},
	{	"(!`u)",	"\227"	},
	{	"(!`A)",	"A"		},
	{	"(!`E)",	"E"		},
	{	"(!`I)",	"I"		},
	{	"(!`O)",	"O"		},
	{	"(!`U)",	"U"		},	/* 10 */

	{	"(!^a)",	"\203"	},
	{	"(!^e)",	"\210"	},
	{	"(!^i)",	"\214"	},
	{	"(!^o)",	"\223"	},
	{	"(!^u)",	"\226"	},
	{	"(!^A)",	"A"		},
	{	"(!^E)",	"E"		},
	{	"(!^I)",	"I"		},
	{	"(!^O)",	"O"		},
	{	"(!^U)",	"U"		},	/* 10 */

	{	"(!~a)",	"a"		},
	{	"(!~n)",	"\244"	},
	{	"(!~o)",	"o"		},
	{	"(!~A)",	"A"		},
	{	"(!~N)",	"\245"	},
	{	"(!~O)",	"O"		},	/*  6 */

	{	"(!.a)",	"\206"	},
	{	"(!.A)",	"\217"	},	/*  2 */

	{	"(!&ae)",	"\221"	},
	{	"(!&AE)",	"\222"	},
	{	"(!&oe)",	"oe"	},
	{	"(!&OE)",	"OE"	},	/*  4 */

	{	"(!,c)",	"\207"	},
	{	"(!,C)",	"\200"	},	/*  2 */

	{	"(!_a)",	"\246"	},
	{	"(!_o)",	"\247"	},	/*  2 */

	{	"(!\\o)",	"o"		},
	{	"(!\\O)",	"O"		},	/*  2 */

	{	"(!#S)",	"\335"	},
};

/*	############################################################
	# chr_dos.h
	############################################################	*/
