/* BEGIN_COMMON_COPYRIGHT_HEADER
 * (c)LGPL2+
 *
 * LXQt - a lightweight, Qt based, desktop toolset
 * https://lxqt.org
 *
 * Copyright: 2015 LXQt team
 * Authors:
 *  Balázs Béla <balazsbela[at]gmail.com>
 *  Paulo Lieuthier <paulolieuthier@gmail.com>
 *
 * This program or library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * END_COMMON_COPYRIGHT_HEADER */
#ifndef STATUSNOTIFERSCROLLAREA_H
#define STATUSNOTIFERSCROLLAREA_H
#include <QScrollBar>
#include <QScrollArea>
#include <QWidget>
#include "../panel/iukuipanelplugin.h"
#include "../panel/common/ukuigridlayout.h"
#include "../panel/pluginsettings.h"
#include "statusnotifierwidget.h"
#include "statusnotifierbutton.h"
#include "statusnotifierwatcher.h"
#include "statusnotifier_storagearrow.h"
#include "statusnotifierbuttonabstract.h"

/*****************************************************
**托盘滚动区域布局
-----------------------------------------------
|            Active Area         |  Fixed Area
|           |           |        |
|  Storage  |  Storage  |  Show  |
|   Area    |   Arrow   |  Area  |
-----------------------------------------------

Active Area：
    Storage Area：图标可收纳、可拖拽
    Show Area：图标不可收纳、可拖拽
    Storage Arrow：切换收纳区图标的显示和隐藏状态
Fixed Area：固定区内图标不可拖拽、不可收纳
*****************************************************/
class StatusNotiferScrollArea : public QScrollArea
{
    Q_OBJECT
public:
    StatusNotiferScrollArea(IUKUIPanelPlugin *plugin, QWidget *parent = 0);
    ~StatusNotiferScrollArea();
    enum Status{PASSIVE=0, ACTIVE, NEEDSATTENTION};
    enum ActionArea{UNDEFINED=0,STORAGE,SHOW,FIXED};

protected:
    void wheelEvent(QWheelEvent* event);

public Q_SLOTS:
    void realign();
    void itemAdded(QString serviceAndPath);
    void itemRemoved(const QString &serviceAndPath);

private Q_SLOTS:
    void switchButtons(StatusNotifierButtonAbstract *srcButton, StatusNotifierButtonAbstract *dstButton);
    void arrowbtnAddButton(StatusNotifierButtonAbstract *srcButton, StatusNotifierButtonAbstract *dstButton);
    void tabletPcSwitch(bool state);

private:
    void saveSettings(QString button1,QString button2);
    QList<QStringList> readSettings();
    QStringList readFixedAppSettings();
    void resetLayout();
    void exchangeHideAndShow();
    QString getDisplayId(QString pid);

private:
    IUKUIPanelPlugin *m_plugin;
    QWidget *m_parent;
    QWidget *m_outWidget; //最外层大窗口，是托盘活动区和托盘固定区的父窗口
    QWidget *m_statusNotifierWidget;    //托盘活动区窗口
    QWidget *m_statusNotifierFixedWidget; //托盘固定区窗口（不允许图标拖动）
    QGSettings *m_btnIsShowgsettings = nullptr;
    UKUi::GridLayout *m_layout;
    UKUi::GridLayout *m_layoutFix;
    QGridLayout *m_outLayout;
    StatusNotifierWatcher *m_watcher;

    QHash<QString, StatusNotifierButton*> m_services;
    QMap<QString,StatusNotifierButton*> m_showButtons;
    QMap<QString,StatusNotifierButton*> m_hideButtons;
    QMap<QString,StatusNotifierButton*> m_allButtons;
    QMap<QString,StatusNotifierButton*> m_activeButtons;
    QMap<QString,StatusNotifierButton*> m_layoutButtons;
    QMap<QString,StatusNotifierButton*> m_fixedButtons;

    QList<StatusNotifierButton*> m_statusNotifierButtons;
    QList<StatusNotifierButton*> m_statusNotifierFixedButtons;
    StatusNotifierStorageArrow *m_arrowBtn;
    QGSettings *m_gsettings = nullptr;
};

#endif // STATUSNOTIFERSCROLLAREA_H
