/* powerpc64le-linux.kernel.vmlinux.h
   created from powerpc64le-linux.kernel.vmlinux.bin, 11056 (0x2b30) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2017 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2017 Laszlo Molnar
   Copyright (C) 2000-2017 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_POWERPC64LE_LINUX_KERNEL_VMLINUX_SIZE    11056
#define STUB_POWERPC64LE_LINUX_KERNEL_VMLINUX_ADLER32 0x378f2a22
#define STUB_POWERPC64LE_LINUX_KERNEL_VMLINUX_CRC32   0x7d627503

unsigned char stub_powerpc64le_linux_kernel_vmlinux[11056] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 21,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0, 56, 30,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,
/* 0x0040 */   0,  0,  0, 72,  0,  0,  0, 72,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0050 */ 208,  0,  6, 40, 32,  0,194, 76,191,240,132, 84, 32,  0,194, 77,
/* 0x0060 */  16,  0,  0, 60, 64,  0,  4,124,  8,  0,128, 65,120,  3,  4,124,
/* 0x0070 */  32,  1,165, 56,120, 27,103,124,252,255, 99, 56,166,  3,137,124,
/* 0x0080 */  28,  0,  0, 72,186,  2, 75, 84, 80, 88, 99,125, 20, 58,107,125,
/* 0x0090 */ 186,  1, 98, 81,  0,  0, 67,144, 32,  0, 64, 79,  4,  0, 67,132,
/* 0x00a0 */ 190, 85, 75, 84, 64, 40, 11,124,220,255,194, 65,240,255, 32, 67,
/* 0x00b0 */  32,  0,128, 78,236, 41,  0,124,166,  2,168,125,  2,  0,  7, 40,
/* 0x00c0 */  12,  1,130, 64,  0,  0,166,248, 20, 26,132,124,  0,128,  0, 60,
/* 0x00d0 */ 198,  7,  0,120,  0,128, 32, 61,198,  7, 41,121,255,255, 99, 56,
/* 0x00e0 */ 255,255,165, 56,255,255, 64, 57,212,  0,  0, 72, 64,  0, 41,124,
/* 0x00f0 */  20, 72, 41,125, 32,  0,226, 76,  0,  0,128, 57, 20, 97,140,125,
/* 0x0100 */ 198,  7,140,121,  1,  0, 32, 57, 46, 24, 41,125,  4,  0, 99, 56,
/* 0x0110 */ 198,  7, 41,121, 64,  0, 41,124, 20, 72, 41,125, 20, 98, 41,125,
/* 0x0120 */  32,  0,128, 78,  1,  0,  3,141,  1,  0,  5,157,193,255,255, 75,
/* 0x0130 */ 244,255,225, 65,  1,  0,224, 56,181,255,255, 75, 21, 57,231,124,
/* 0x0140 */ 173,255,255, 75,244,255,192, 65,253,255,231, 52,  0,  0,  0, 57,
/* 0x0150 */  32,  0,192, 65, 46, 64,231, 84,  1,  0, 67,140,249, 16,234,124,
/* 0x0160 */ 255,255,128, 57,198,  7,140,121,  0, 96, 42,124,  0,  0,194, 65,
/* 0x0170 */ 125,255,255, 75, 21, 65,  8,125,117,255,255, 75, 21, 65,  8,125,
/* 0x0180 */   1,  0,224, 56, 28,  0,194, 64,  3,  0,224, 56,  1,  0,  0, 57,
/* 0x0190 */  93,255,255, 75, 21, 65,  8,125, 85,255,255, 75,244,255,192, 65,
/* 0x01a0 */ 255,242, 74, 32, 20, 57,  8,125, 20, 42,234,124,166,  3,  9,125,
/* 0x01b0 */   1,  0,  7,141,  1,  0,  5,157,248,255, 32, 67,  0,  1,224, 56,
/* 0x01c0 */ 236, 41,  7,124, 44, 26,  7,124,100,255,255, 75,236, 41,  0,124,
/* 0x01d0 */ 166,  2,168,125,  5,  0,  7, 40, 56,  1,130, 64,  0,  0,166,248,
/* 0x01e0 */  20, 26,132,124,  0,128,  0, 60,198,  7,  0,120,  0,128, 32, 61,
/* 0x01f0 */ 198,  7, 41,121,255,255, 99, 56,255,255,165, 56,255,255, 64, 57,
/* 0x0200 */   0,  1,  0, 72,  1,  0, 32, 57, 46, 24, 41,125,  4,  0, 99, 56,
/* 0x0210 */ 198,  7, 41,121, 64,  0, 41,124, 20, 72, 41,125,  1,  0,128, 57,
/* 0x0220 */ 198,  7,140,121,120, 99, 41,125, 32,  0,128, 78,  1,  0,  3,141,
/* 0x0230 */   1,  0,  5,157, 64,  0, 41,124, 20, 74, 41,125,201,255,194, 65,
/* 0x0240 */ 236,255,225, 65,  1,  0,224, 56, 20,  0,  0, 72,255,255,231, 56,
/* 0x0250 */  21, 72, 41,125,177,255,194, 65, 21, 57,231,124, 21, 72, 41,125,
/* 0x0260 */ 165,255,194, 65, 21, 57,231,124, 64,  0, 41,124, 20, 74, 41,125,
/* 0x0270 */ 149,255,194, 65,216,255,192, 65,  0,  0,  0, 57,253,255,231, 52,
/* 0x0280 */  46, 64,231, 84, 28,  0,192, 65,  1,  0, 67,140,249, 16,234,124,
/* 0x0290 */ 112, 14, 74,125,  0,  0, 42, 44,  0,  0,194, 65, 12,  0,  0, 72,
/* 0x02a0 */  21, 72, 41,125, 97,255,194, 65, 21, 65,  8,125, 21, 72, 41,125,
/* 0x02b0 */  85,255,194, 65, 21, 65,  8,125, 40,  0,130, 64,  1,  0,  0, 57,
/* 0x02c0 */  21, 72, 41,125, 65,255,194, 65, 21, 65,  8,125, 64,  0, 41,124,
/* 0x02d0 */  20, 74, 41,125, 49,255,194, 65,232,255,192, 65,  2,  0,  8, 57,
/* 0x02e0 */ 255,250,234, 32,  1,  0,  8, 57,148,  1,  8,125, 20, 42,234,124,
/* 0x02f0 */ 166,  3,  9,125,  1,  0,  7,141,  1,  0,  5,157,248,255, 32, 67,
/* 0x0300 */   0,  1,224, 56,236, 41,  7,124, 44, 26,  7,124, 40,255,255, 75,
/* 0x0310 */ 236, 41,  0,124,166,  2,168,125,  8,  0,  7, 40, 92,  1,130, 64,
/* 0x0320 */   0,  0,166,248, 20, 26,132,124,  0,128,  0, 60,198,  7,  0,120,
/* 0x0330 */   0,128, 32, 61,198,  7, 41,121,255,255, 99, 56,255,255,165, 56,
/* 0x0340 */ 255,255, 64, 57, 36,  1,  0, 72,  1,  0, 32, 57, 46, 24, 41,125,
/* 0x0350 */   4,  0, 99, 56,198,  7, 41,121, 64,  0, 41,124, 20, 72, 41,125,
/* 0x0360 */   1,  0,128, 57,198,  7,140,121,120, 99, 41,125, 32,  0,128, 78,
/* 0x0370 */   1,  0,  3,141,  1,  0,  5,157, 64,  0, 41,124, 20, 74, 41,125,
/* 0x0380 */ 201,255,194, 65,236,255,225, 65,  1,  0,224, 56, 20,  0,  0, 72,
/* 0x0390 */ 255,255,231, 56, 21, 72, 41,125,177,255,194, 65, 20, 57,231,124,
/* 0x03a0 */  21, 72, 41,125,165,255,194, 65, 20, 57,231,124, 64,  0, 41,124,
/* 0x03b0 */  20, 74, 41,125,149,255,194, 65,216,255,192, 65,  0,  0,  0, 57,
/* 0x03c0 */ 253,255,231, 52, 46, 64,231, 84,255,255,128, 57,198,  7,140,121,
/* 0x03d0 */ 120, 99,231,124, 32,  0,192, 65,  1,  0, 67,140,249, 16,234,124,
/* 0x03e0 */ 112, 14, 74,125,  0,  0,194, 65,  1,  0, 66,112, 80,  0,226, 65,
/* 0x03f0 */  20,  0,  0, 72, 64,  0, 41,124, 20, 74, 41,125, 77,255,194, 65,
/* 0x0400 */  60,  0,225, 65,  1,  0,  0, 57, 64,  0, 41,124, 20, 74, 41,125,
/* 0x0410 */  57,255,194, 65, 40,  0,225, 65, 21, 72, 41,125, 45,255,194, 65,
/* 0x0420 */  20, 65,  8,125, 64,  0, 41,124, 20, 74, 41,125, 29,255,194, 65,
/* 0x0430 */ 232,255,192, 65,  2,  0,  8, 57, 16,  0,  0, 72, 21, 72, 41,125,
/* 0x0440 */   9,255,194, 65, 20, 65,  8,125,255,250,234, 32,  2,  0,  8, 57,
/* 0x0450 */ 148,  1,  8,125, 20, 42,234,124,166,  3,  9,125,  1,  0,  7,141,
/* 0x0460 */   1,  0,  5,157,248,255, 32, 67,  0,  1,224, 56,236, 41,  7,124,
/* 0x0470 */  44, 26,  7,124,  4,255,255, 75,  0,  0,230,232,166,  3,168,125,
/* 0x0480 */  80, 24,100,124, 80, 40,135,124,  1,  0, 99, 56,  1,  0,132, 56,
/* 0x0490 */   0,  0,134,248, 31,  0,231, 96,108, 56,  0,124, 64, 40, 39,124,
/* 0x04a0 */ 172, 63,  0,124, 32,  0,231, 56,240,255,128, 65,172,  4,  0,124,
/* 0x04b0 */  44,  1,  0, 76, 32,  0,128, 78, 14,  0,  7, 40,  0,  0,130, 64,
/* 0x04c0 */ 209,255, 33,248,166,  2,  8,124,120, 51,201,124,  0,  0,  6,129,
/* 0x04d0 */ 120, 43,167,124,254,255,164, 56,  2,  0,131, 56, 16,  0,  1,248,
/* 0x04e0 */   0,  0,  3,136,194,232, 11,120, 96,  7,  2,120,  0,250, 96, 56,
/* 0x04f0 */  54, 88, 99,124,100,241, 99, 56,120, 11, 38,124, 20, 26, 33,124,
/* 0x0500 */ 164,  6, 33,120,  0,  0,  0, 56,120, 51,195,124,  0,  0,  9,248,
/* 0x0510 */ 249,255,  3,248, 64, 24, 33,124,248,255,128, 65,  0,  0,193,248,
/* 0x0520 */ 255,255,  4,136, 32,  0,193, 56, 40,  0, 97, 56, 16,  0,225,248,
/* 0x0530 */  24,  0, 33,249,  2,225, 11,120, 32,  7,  0,120,  2,  0, 67,152,
/* 0x0540 */   1,  0, 99,153,  0,  0,  3,152,209,255, 33,248,166,  2,  8,124,
/* 0x0550 */   1,  0, 64, 57,  1,  0,  0, 72,  2,  0, 99,137,  4,  0, 99, 59,
/* 0x0560 */  48, 88, 75,125,255,255,107, 57, 32,  0,107,121, 96,255, 97,249,
/* 0x0570 */   1,  0, 99,137,  2,  0,227, 59, 48, 88, 74,125,255,255, 74, 57,
/* 0x0580 */   0,  0, 96, 57, 32,  0, 74,121,166,  3, 72,125,  0,  0, 67,137,
/* 0x0590 */   0,  0,102,145,  0,  0,105,145,180,  7, 84,125,  1,  0, 99,137,
/* 0x05a0 */   0,  4,  0, 56, 20, 82, 75,125,  0,  3, 96, 57, 48, 80,106,125,
/* 0x05b0 */  54,  7, 74, 57, 32,  0, 74,121,  0,  0,138, 47,  1,  0,106, 57,
/* 0x05c0 */   8,  0,190, 64,  1,  0, 96, 57,255,255,107, 53, 12,  0,130, 65,
/* 0x05d0 */   2,  0, 31,180,244,255,255, 75,  5,  0,  0, 56,166,  3,  9,124,
/* 0x05e0 */  20, 42,164,124,  5,  0,100, 57,120, 35,159,124,  0,  0, 64, 57,
/* 0x05f0 */  64, 40,191,127, 12,  0,190, 64,  1,  0, 96, 56, 88, 10,  0, 72,
/* 0x0600 */   1,  0,255, 59,255,255, 31,136, 46, 64, 74, 85,120, 83, 10,124,
/* 0x0610 */  32,  0, 74,121,220,255,  0, 66,255,255,  0, 56,255,  0, 32, 63,
/* 0x0620 */  32,  0,  0,120,  1,  0,160, 58,  1,  0,  0, 59,  1,  0,192, 58,
/* 0x0630 */   1,  0,160, 59,  0,  0,128, 57,  0,  0,192, 59,  0,  0, 64, 59,
/* 0x0640 */ 255,255, 57, 99,  1,  0, 96, 58,  8,  0, 84, 34, 64, 64,154,127,
/* 0x0650 */ 216,  9,156, 64, 96,255,225,235, 54, 32,156, 85, 56,248, 87,127,
/* 0x0660 */  64,200,128,127,180,  7,241,126,180,  7,156,127, 20,226,145,127,
/* 0x0670 */ 164, 15,145,123, 36,  0,157, 65, 64, 40,171,127,124,255,190, 65,
/* 0x0680 */   0,  0,235,139, 46, 64, 74, 85,120, 83,234,127, 40, 64,  0,120,
/* 0x0690 */  32,  0, 74,121,  1,  0,107, 57, 46,138,251,125,254,170, 16, 84,
/* 0x06a0 */ 214,121, 16,126, 64,128,138,127, 32,  0, 28,122,228,  1,156, 64,
/* 0x06b0 */   0,  8,239, 35,112, 46,255,127,166,  2,  8,124, 20,122,255,127,
/* 0x06c0 */  46,139,251,127, 48,150,223,127, 56,  0, 94,127, 48,160,222,127,
/* 0x06d0 */  20,242,223,127,  0,  3,222, 31,  6,  0,140, 47, 32,  0,222,123,
/* 0x06e0 */  54,  7,222, 59,164, 15,222,123, 20,242,219,127, 16,  0,157, 65,
/* 0x06f0 */   1,  0,224, 59,120,227,128,127, 12,  1,  0, 72, 80,208, 29,124,
/* 0x0700 */  32,  0,  0,120,174,  0,231,125,  1,  0,224, 59, 60,  8,247, 85,
/* 0x0710 */ 180,  7,239,126,238,  5,247, 86,180,  7,247,126, 64,200,156,127,
/* 0x0720 */   0,  1, 55, 58, 20,250, 49,126,164, 15, 49,122, 36,  0,157, 65,
/* 0x0730 */  64, 40,171,127,196,254,190, 65,  0,  0, 11,136, 46, 64, 74, 85,
/* 0x0740 */ 120, 83, 10,124, 40, 64,156,123, 32,  0, 74,121,  1,  0,107, 57,
/* 0x0750 */  46,138, 30,126,254,170,128, 87,214,129,  0,124, 60,  8,255, 87,
/* 0x0760 */  64,  0, 10,127, 32,  0, 14,120,  0,  0,183, 47, 36,  0,152, 64,
/* 0x0770 */   0,  8, 16, 32,112, 46,  0,124, 20,130,  0,126, 46,139, 30,126,
/* 0x0780 */ 180,  7,255,127,120,115,220,125, 48,  0,190, 65,104,255,255, 75,
/* 0x0790 */  80,224,128,127, 80, 80, 64,125,126,217,  0, 86, 80,128,  0,126,
/* 0x07a0 */   1,  0,255, 59, 32,  0,156,123, 32,  0, 74,121, 46,139, 30,126,
/* 0x07b0 */ 180,  7,255,127, 64,255,190, 65,255,  0,159, 47, 80,255,157, 64,
/* 0x07c0 */  52,255,255, 75, 64,200,128,127,164, 15,241,123, 68,  0,157, 64,
/* 0x07d0 */  46,138,254,126,254,170, 28, 84,214,185,156,127, 60,  8,255, 87,
/* 0x07e0 */  64,224,138,127, 32,  0,144,123, 76,  0,156, 64,  0,  8,151, 35,
/* 0x07f0 */ 112, 46,156,127, 20,186,156,127, 46,139,158,127,180,  7,255,127,
/* 0x0800 */ 120,131,  0,126,255,  0,159, 47,188,255,157, 64, 80,  0,  0, 72,
/* 0x0810 */  64, 40,171,127,228,253,190, 65,  0,  0,139,139, 46, 64, 74, 85,
/* 0x0820 */ 120, 83,138,127, 40, 64,  0,120, 32,  0, 74,121,  1,  0,107, 57,
/* 0x0830 */ 160,255,255, 75, 80,  0, 28,124, 80, 80, 92,125,126,217,252, 86,
/* 0x0840 */  80,184,156,127,  1,  0,255, 59, 32,  0, 74,121, 46,139,158,127,
/* 0x0850 */ 180,  7,255,127, 32,  0, 16,120,168,255,255, 75,  3,  0,140, 47,
/* 0x0860 */  32,  6,254,123,  1,  0,154, 59, 32,  0,156,123,174,209,199,127,
/* 0x0870 */ 172,  7,157, 64,  9,  0,140, 47, 12,  0,157, 65,253,255,140, 57,
/* 0x0880 */   8,  0,  0, 72,250,255,140, 57,180,  7,140,125,148,  7,  0, 72,
/* 0x0890 */  80,  0, 16,124, 64,200,128,127,126,217,255, 85, 80, 80, 16,126,
/* 0x08a0 */  80,120,255,127,192,  0,204, 59, 32,  0, 28,120, 32,  0, 10,122,
/* 0x08b0 */  46,139,251,127,164, 15,222,123, 36,  0,157, 65, 64, 40,171,127,
/* 0x08c0 */  56,253,190, 65,  0,  0, 75,137, 46, 64, 16, 86,120,131, 74,125,
/* 0x08d0 */  40, 64, 28,120, 32,  0, 74,121,  1,  0,107, 57, 46,242, 27,124,
/* 0x08e0 */ 254,170,159, 87,214,  1, 31,126, 64,128,138,127, 32,  0, 31,122,
/* 0x08f0 */  68,  0,156, 64,  7,  0,140, 47,  0,  8,128, 35,112, 46,156,127,
/* 0x0900 */  38,  0,128,125,254,239,140, 85, 20,  2, 28,124,208,  0,140,125,
/* 0x0910 */  66,240,140,121,  0, 16,140,121, 46,243, 27,124,120,195, 21,127,
/* 0x0920 */   3,  0,140, 57,120,179,216,126,104,  6,195, 59,120,235,182,127,
/* 0x0930 */ 124,  2,  0, 72, 80,224,240,125, 64,200,143,127, 80, 80,240,127,
/* 0x0940 */ 126,217, 16, 84, 80,  0, 16,124, 32,  0,252,121, 32,  0,234,123,
/* 0x0950 */  46,243, 27,124, 24,  0, 30, 58, 36,  0,157, 65, 64, 40,171,127,
/* 0x0960 */ 152,252,190, 65,  0,  0, 11,136, 46, 64,234, 87,120, 83, 10,124,
/* 0x0970 */  40, 64,252,121, 32,  0, 74,121,  1,  0,107, 57, 46,130,251,125,
/* 0x0980 */ 254,170,128, 87,214,121,  0,124, 64,  0,138,127, 32,  0, 31,120,
/* 0x0990 */ 208,  0,156, 64,  0,  8,207, 35, 64,200,128,127,112, 46,222,127,
/* 0x09a0 */  20,122,254,125, 46,131,251,125,224,  1,145, 59, 36,  0,157, 65,
/* 0x09b0 */  64, 40,171,127, 68,252,190, 65, 40, 64, 31,120,  0,  0, 11,136,
/* 0x09c0 */  46, 64, 74, 85,120, 83, 10,124, 32,  0, 74,121,  1,  0,107, 57,
/* 0x09d0 */  46,226, 59,126,254,170,254, 87,214,137,222,127, 64,240,138,127,
/* 0x09e0 */  32,  0,192,123, 80,  0,156, 64,  0,  8,241, 35,  0,  0,186, 47,
/* 0x09f0 */ 112, 46,255,127, 20,138, 63,126, 46,227, 59,126,252,251,190, 65,
/* 0x0a00 */   7,  0,140, 47, 80,208,253,127, 32,  0,255,123, 38,  0,128,125,
/* 0x0a10 */ 254,239,140, 85,174,248,199,127,208,  0,140,125,164,  7,140,121,
/* 0x0a20 */   1,  0,154, 59, 11,  0,140, 57, 32,  0,156,123,174,209,199,127,
/* 0x0a30 */ 240,  5,  0, 72,126,217, 32, 86, 80,136, 32,126, 80,248,254,127,
/* 0x0a40 */  80, 80, 94,125,120,195,  0,127, 32,  0,255,123,120,235,184,127,
/* 0x0a50 */  32,  0, 74,121, 46,227, 59,126,120,179,221,126,124,  0,  0, 72,
/* 0x0a60 */  80,224,128,127, 64,200,156,127,126,217,255, 85, 80, 80,  0,124,
/* 0x0a70 */  80,120,255,127, 46,131,251,127, 32,  0,145,123, 32,  0, 10,120,
/* 0x0a80 */  48,  0, 30, 58, 36,  0,157, 65, 64, 40,171,127,108,251,190, 65,
/* 0x0a90 */   0,  0, 75,137, 46, 64,  0, 84,120,  3, 74,125, 40, 64,145,123,
/* 0x0aa0 */  32,  0, 74,121,  1,  0,107, 57, 46,130, 27,124,254,170, 63, 86,
/* 0x0ab0 */ 214,  1,255,125, 64,120,138,127, 32,  0,255,121, 36,  0,156, 64,
/* 0x0ac0 */   0,  8,192, 35,112, 46,222,127, 20,  2, 30,124, 46,131, 27,124,
/* 0x0ad0 */ 120,195,  0,127,120,179,216,126,120,  3, 22,124,160,  0,  0, 72,
/* 0x0ae0 */  80,136, 47,126, 64,200,145,127, 80, 80,239,127,126,217, 15, 84,
/* 0x0af0 */  80,  0, 15,124, 32,  0, 60,122, 32,  0,234,123, 46,131, 27,124,
/* 0x0b00 */  72,  0,222, 59, 36,  0,157, 65, 64, 40,171,127,236,250,190, 65,
/* 0x0b10 */   0,  0, 11,136, 46, 64,234, 87,120, 83, 10,124, 40, 64, 60,122,
/* 0x0b20 */  32,  0, 74,121,  1,  0,107, 57, 46,242, 59,126,254,170,128, 87,
/* 0x0b30 */ 214,137,  0,124, 64,  0,138,127, 32,  0, 31,120, 24,  0,156, 64,
/* 0x0b40 */   0,  8, 17, 32,112, 46,  0,124, 20,138,  0,124, 46,243, 27,124,
/* 0x0b50 */  44,  0,  0, 72, 80,224,224,127, 80, 80, 64,125,126,217, 32, 86,
/* 0x0b60 */  80,136,  0,124, 46,243, 27,124,120,195,  0,127, 32,  0, 74,121,
/* 0x0b70 */ 120,171,184,126, 32,  0,255,123,120,  3, 21,124,  7,  0,140, 47,
/* 0x0b80 */ 120,235,160,127,108, 10,195, 59, 38,  0,128,125,254,239,140, 85,
/* 0x0b90 */ 120,195, 29,127,208,  0,140,125, 66,240,140,121,  0, 16,140,121,
/* 0x0ba0 */ 120,179,216,126, 11,  0,140, 57,120,  3, 22,124, 64,200,159,127,
/* 0x0bb0 */  36,  0,157, 65, 64, 40,171,127, 64,250,190, 65,  0,  0, 11,136,
/* 0x0bc0 */  46, 64, 74, 85,120, 83, 10,124, 40, 64,255,123, 32,  0, 74,121,
/* 0x0bd0 */   1,  0,107, 57,  0,  0, 30,162,254,170,252, 87,214,129,156,127,
/* 0x0be0 */  64,224,138,127, 32,  0,128,123, 48,  0,156, 64, 56, 24,247, 86,
/* 0x0bf0 */   0,  8,240, 35,180,  7,247,126,112, 46,255,127,  2,  0,247, 58,
/* 0x0c00 */  20,130, 31,126,164, 15,247,122,  0,  0, 30,178,  0,  0,192, 57,
/* 0x0c10 */  20,186,222,127,136,  0,  0, 72, 80,248,252,127, 64,200,159,127,
/* 0x0c20 */ 126,217,  0, 86, 80, 80,156,127, 80,128,  0,126, 32,  0,241,123,
/* 0x0c30 */  32,  0,138,123,  0,  0, 30,178, 36,  0,157, 65, 64, 40,171,127,
/* 0x0c40 */ 184,249,190, 65,  0,  0, 75,137, 46, 64,156, 87,120,227, 74,125,
/* 0x0c50 */  40, 64,241,123, 32,  0, 74,121,  1,  0,107, 57,  2,  0,158,163,
/* 0x0c60 */ 254,170, 63, 86,214,225,255,127, 64,248,138,127, 32,  0,224,123,
/* 0x0c70 */  52,  0,156, 64, 56, 24,247, 86,  0,  8,252, 35,180,  7,247,126,
/* 0x0c80 */ 112, 46,255,127,130,  0,247, 58, 20,226,255,127,164, 15,247,122,
/* 0x0c90 */   2,  0,254,179,  8,  0,192, 57, 20,186,222,127,  3,  0,224, 57,
/* 0x0ca0 */  44,  0,  0, 72, 80,136, 31,124, 80, 80, 95,125,126,217,159, 87,
/* 0x0cb0 */  80,224,255,127,  2,  0,254,179, 32,  0, 74,121,  4,  2,222, 59,
/* 0x0cc0 */  32,  0,  0,120, 16,  0,192, 57,  8,  0,224, 57,255,255,143, 59,
/* 0x0cd0 */  32,  0,156,123,  1,  0,156, 59,166,  3,137,127,  1,  0,224, 59,
/* 0x0ce0 */  64,200,128,127,164, 15,240,123, 20,130, 30,126, 36,  0,157, 65,
/* 0x0cf0 */  64, 40,171,127,  4,249,190, 65,  0,  0,139,139, 46, 64, 74, 85,
/* 0x0d00 */ 120, 83,138,127, 40, 64,  0,120, 32,  0, 74,121,  1,  0,107, 57,
/* 0x0d10 */   0,  0, 48,162,254,170, 23, 84,214,137,247,126, 60,  8,255, 87,
/* 0x0d20 */  64,184,138,127, 32,  0,252,122, 32,  0,156, 64,  0,  8, 17, 32,
/* 0x0d30 */ 112, 46,  0,124, 20,138, 32,126,  0,  0, 48,178,180,  7,255,127,
/* 0x0d40 */ 120,227,128,127, 40,  0,  0, 72,126,217, 60, 86, 80,136, 60,126,
/* 0x0d50 */  80,  0, 23,124, 80, 80, 87,125,  1,  0,255, 59,  0,  0, 48,178,
/* 0x0d60 */  32,  0,  0,120, 32,  0, 74,121,180,  7,255,127,116,255,  0, 66,
/* 0x0d70 */   3,  0,140, 47, 48,120,111,126, 80,112,239,125, 20,250,143,127,
/* 0x0d80 */  80,  2,157, 65,  3,  0,156, 47,120,227,159,127,  8,  0,157, 64,
/* 0x0d90 */   3,  0,224, 59,  6,  0,192, 59, 50, 48,255, 87,166,  3,201,127,
/* 0x0da0 */ 180,  7,255,127,176,  1,255, 59,164, 15,253,123,  1,  0,224, 59,
/* 0x0db0 */  64,200,128,127,164, 15,241,123, 20,234, 49,126, 36,  0,157, 65,
/* 0x0dc0 */  64, 40,171,127, 52,248,190, 65,  0,  0,203,139, 46, 64, 74, 85,
/* 0x0dd0 */ 120, 83,202,127, 40, 64,  0,120, 32,  0, 74,121,  1,  0,107, 57,
/* 0x0de0 */  46,138,251,126,254,170, 30, 84,214,185,222,127, 60,  8,255, 87,
/* 0x0df0 */  64,240,138,127, 32,  0,208,123, 32,  0,156, 64,  0,  8,215, 35,
/* 0x0e00 */ 112, 46,222,127, 20,186,222,127, 46,139,219,127,180,  7,255,127,
/* 0x0e10 */ 120,131,  0,126, 40,  0,  0, 72, 80,  0, 30,124, 80, 80, 94,125,
/* 0x0e20 */ 126,217,254, 86, 80,184,222,127,  1,  0,255, 59, 46,139,219,127,
/* 0x0e30 */  32,  0,  0,120, 32,  0, 74,121,180,  7,255,127,116,255,  0, 66,
/* 0x0e40 */ 192,255,223, 59,  3,  0,158, 47,180,  7,215,127,108,  1,157, 64,
/* 0x0e50 */  13,  0,158, 47,254,  7,223, 87,  2,  0,240, 99,112, 14,221,127,
/* 0x0e60 */  32,  0, 17,122, 40,  0,157, 65,255,255,221, 59, 48,240, 31,126,
/* 0x0e70 */ 180,  7,221,127,176,  2,215, 35, 20,250,222,127,164, 15,222,123,
/* 0x0e80 */ 254,255,222, 59, 20,242,219,127,116,  0,  0, 72,250,255,221, 59,
/* 0x0e90 */  32,  0,222,123,  1,  0,222, 59,166,  3,201,127, 64,200,128,127,
/* 0x0ea0 */  36,  0,157, 65, 64, 40,171,127, 80,247,190, 65,  0,  0,235,139,
/* 0x0eb0 */  46, 64, 74, 85,120, 83,234,127, 40, 64,  0,120, 32,  0, 74,121,
/* 0x0ec0 */   1,  0,107, 57,126,248, 29, 84, 64,232,138,127, 60,  8, 63, 86,
/* 0x0ed0 */  32,  0,160,123, 32,  0,241,123, 20,  0,156, 65, 80, 80, 93,125,
/* 0x0ee0 */   1,  0,255, 99, 32,  0, 74,121, 32,  0,241,123,176,255,  0, 66,
/* 0x0ef0 */  72,  6,195, 59, 40, 32, 63,122,  4,  0,160, 59,255,255,189, 59,
/* 0x0f00 */  32,  0,189,123,  1,  0,189, 59,166,  3,169,127,  1,  0,224, 58,
/* 0x0f10 */   1,  0,224, 57, 64,200,128,127,164, 15,241,122, 20,138, 62,126,
/* 0x0f20 */  36,  0,157, 65, 64, 40,171,127,208,246,190, 65,  0,  0,171,139,
/* 0x0f30 */  46, 64, 74, 85,120, 83,170,127, 40, 64,  0,120, 32,  0, 74,121,
/* 0x0f40 */   1,  0,107, 57,  0,  0, 17,162,254,170, 29, 84,214,129,189,127,
/* 0x0f50 */  60,  8,247, 86, 64,232,138,127, 32,  0,174,123, 32,  0,156, 64,
/* 0x0f60 */   0,  8, 16, 32,112, 46,  0,124, 20,130,  0,126,  0,  0, 17,178,
/* 0x0f70 */ 180,  7,247,126,120,115,192,125, 48,  0,  0, 72, 80,  0, 29,124,
/* 0x0f80 */  80, 80, 93,125,126,217, 29, 86, 80,128, 29,126,  1,  0,247, 58,
/* 0x0f90 */ 120,251,255,125,  0,  0, 17,178, 32,  0,  0,120, 32,  0, 74,121,
/* 0x0fa0 */ 180,  7,247,126, 32,  0,255,123, 60,  8,239, 85,180,  7,239,125,
/* 0x0fb0 */ 100,255,  0, 66,  8,  0,  0, 72, 32,  0,223,123,  1,  0,255, 59,
/* 0x0fc0 */  33,  0,253,123,100,  0,130, 65,  7,  0,140, 57,180,  7,140,125,
/* 0x0fd0 */  64,208,157,127,  2,  0,252, 59,180,  7,255,127, 28,246,189, 65,
/* 0x0fe0 */ 255,255,255, 59, 32,  0,255,123,  1,  0,255, 59,166,  3,233,127,
/* 0x0ff0 */  80,208,253,127, 32,  0,255,123,174,248,199,127,  1,  0,250, 59,
/* 0x1000 */  32,  0,252,123,174,209,199,127, 24,  0, 64, 66, 64, 64,159,127,
/* 0x1010 */ 120,227,154,127,220,255,156, 65,  8,  0,  0, 72,  0,  0,128, 57,
/* 0x1020 */ 120,227,154,127, 40,246,255, 75,255,  0, 64, 61,255,255, 74, 97,
/* 0x1030 */  64, 80,128,127, 16,  0,157, 65, 64, 40,171,127,188,245,190, 65,
/* 0x1040 */   1,  0,107, 57, 80, 88,132,124,  0,  0,134,144,  0,  0, 73,147,
/* 0x1050 */   0,  0, 96, 56,  0,  0,  0, 72,112,255,193,249,120,255,225,249,
/* 0x1060 */ 128,255,  1,250,136,255, 33,250,144,255, 65,250,152,255, 97,250,
/* 0x1070 */ 160,255,129,250,168,255,161,250,176,255,193,250,184,255,225,250,
/* 0x1080 */ 192,255,  1,251,200,255, 33,251,208,255, 65,251,216,255, 97,251,
/* 0x1090 */ 224,255,129,251,232,255,161,251,240,255,193,251,248,255,225,251,
/* 0x10a0 */  16,  0,  1,248, 32,  0,128, 78,112,255,193,233,120,255,225,233,
/* 0x10b0 */ 128,255,  1,234,136,255, 33,234,144,255, 65,234,152,255, 97,234,
/* 0x10c0 */ 160,255,129,234,168,255,161,234,176,255,193,234,184,255,225,234,
/* 0x10d0 */ 192,255,  1,235,200,255, 33,235,208,255, 65,235,216,255, 97,235,
/* 0x10e0 */ 224,255,129,235, 16,  0,  1,232,232,255,161,235,166,  3,  8,124,
/* 0x10f0 */ 240,255,193,235,248,255,225,235, 32,  0,128, 78,  0,  0,  0,  0,
/* 0x1100 */   0,  0,  0,  1,  9,  0,  0, 72, 44, 12,  0, 72,166,  2,  8,124,
/* 0x1110 */ 160,255,129,250, 16,  0,  1,248,112,255,193,249,120,255,225,249,
/* 0x1120 */ 128,255,  1,250,136,255, 33,250,144,255, 65,250,152,255, 97,250,
/* 0x1130 */ 168,255,161,250,176,255,193,250,184,255,225,250,192,255,  1,251,
/* 0x1140 */ 200,255, 33,251,208,255, 65,251,216,255, 97,251,224,255,129,251,
/* 0x1150 */ 232,255,161,251,240,255,193,251,248,255,225,251,  0,  0, 64, 57,
/* 0x1160 */   0,  0,  3,138,  2,  0, 35,138,  1,  0, 67,138,  0,  0, 70,145,
/* 0x1170 */   0,  0, 73,145,  0,  3, 64, 57,  1,  0, 99,137,  1,  0,  0, 56,
/* 0x1180 */  20,130,107,125, 48, 88, 75,125,202,248,139, 47, 48,136, 17,124,
/* 0x1190 */  48,144, 18,124,255,255, 49, 58,255,255, 82, 58,  4,  0,131, 58,
/* 0x11a0 */  32,  0, 49,122, 32,  0, 82,122,180,  7, 16,126, 36,  0,158, 65,
/* 0x11b0 */  53,  7,107, 57,200, 15,107,121,  2,  0, 67, 57, 20, 90,116,125,
/* 0x11c0 */   0,  4,  0, 56,  2,  0, 10,180, 64, 88,170,127,248,255,158, 64,
/* 0x11d0 */  20, 42,164,124, 64, 40,164,127, 20,  2,158, 65,  4,  0,192, 59,
/* 0x11e0 */ 166,  3,201,127,  0,  0, 68,137,  1,  0,100, 57,  5,  0,228, 59,
/* 0x11f0 */  64, 40,171,127, 46, 64, 74, 85,  1,  0,107, 57,240,  1,158, 65,
/* 0x1200 */ 255,255, 11,136,120, 83, 10,124, 32,  0, 74,121,228,255,  0, 66,
/* 0x1210 */   0,  0,168, 47, 16, 11,158, 65,  1,  0,192, 57,  1,  0,  0, 56,
/* 0x1220 */ 166,  3,200,125, 96,255,  1,248,  8,  0, 16, 32,255,255,192, 59,
/* 0x1230 */ 255,  0, 32, 63, 88,255,  1,144, 32,  0,222,123,  1,  0,224, 57,
/* 0x1240 */   0,  0,160, 58,  0,  0, 96, 57,  0,  0,192, 58,255,255, 57, 99,
/* 0x1250 */  56,136,219,126, 54, 32,160, 86, 64,200,158,127,180,  7,125,127,
/* 0x1260 */ 180,  7,  0,124, 20,  2,189,127,164, 15,189,123, 36,  0,157, 65,
/* 0x1270 */  64, 40,191,127,120,  1,158, 65,  0,  0, 31,136, 46, 64, 74, 85,
/* 0x1280 */ 120, 83, 10,124, 40, 64,222,123, 32,  0, 74,121,  1,  0,255, 59,
/* 0x1290 */  46,234,148,127,254,170,218, 87,214,225, 90,127, 64,208,138,127,
/* 0x12a0 */  32,  0, 64,123,160,  1,156, 64, 88,255,193,131,  0,  8,124, 35,
/* 0x12b0 */  48,246,107,125, 56,144,222,126, 48,128,222,127, 20,242,107,125,
/* 0x12c0 */  46, 64,126, 85, 42, 80,107, 85, 80, 88,126,125, 32,  0,107,121,
/* 0x12d0 */   6,  0,149, 47,112, 46,123,127, 54,  7,203, 59, 20,226,155,127,
/* 0x12e0 */ 164, 15,222,123, 46,235,148,127, 20,242,212,127,192,  4,157, 64,
/* 0x12f0 */  80,176,111,125, 32,  0,107,121,174, 88, 71,127,  1,  0, 96, 57,
/* 0x1300 */  28,  0,  0, 72, 46, 99,126,127,180,  7,107,125,120,235,160,127,
/* 0x1310 */ 172,  0,130, 64,255,  0,139, 47,172,  0,157, 65, 60,  8, 90, 87,
/* 0x1320 */ 238,  5, 76, 87,180,  7,140,125,  0,  0, 44, 44, 64,200,128,127,
/* 0x1330 */   0,  1,140, 57, 60,  8,120, 85, 20, 90,140,125, 64, 40, 63,127,
/* 0x1340 */ 120,195, 11,127, 46, 64, 93, 85,  0,  0,128, 76,  1,  0, 24, 59,
/* 0x1350 */ 164, 15,140,121,180,  7, 90,127, 28,  0,157, 65,144,  0,154, 65,
/* 0x1360 */   0,  0, 95,137, 40, 64,  0,120,120,235, 74,125, 32,  0, 74,121,
/* 0x1370 */   1,  0,255, 59, 46, 98,158,127,254,170, 29, 84,214,225,189,127,
/* 0x1380 */   0,  8,124, 35, 64,232,138,127,112, 46,123,127,126,217,151, 87,
/* 0x1390 */  20,226,123,127, 80,  0, 29,124, 80, 80,125,126, 80,224,151,127,
/* 0x13a0 */  32,  0,189,123, 96,255,188, 65, 46, 99,158,127,180,  7, 11,127,
/* 0x13b0 */  32,  0,  0,120, 32,  0,106,122, 92,255,134, 64,255,  0,139, 47,
/* 0x13c0 */   4,  4,189, 64, 32,  6,107,121,  1,  0,182, 59,174,177,103,125,
/* 0x13d0 */ 120,  3, 30,124, 32,  0,182,123,  9,  0,149, 47, 68,  8,157, 65,
/* 0x13e0 */ 253,255,181, 58,180,  7,181,126, 64,  6,  0, 72,  1,  0, 96, 56,
/* 0x13f0 */  16,  0,  1,232,112,255,193,233,166,  3,  8,124,120,255,225,233,
/* 0x1400 */ 128,255,  1,234,136,255, 33,234,144,255, 65,234,152,255, 97,234,
/* 0x1410 */ 160,255,129,234,168,255,161,234,176,255,193,234,184,255,225,234,
/* 0x1420 */ 192,255,  1,235,200,255, 33,235,208,255, 65,235,216,255, 97,235,
/* 0x1430 */ 224,255,129,235,232,255,161,235,240,255,193,235,248,255,225,235,
/* 0x1440 */  32,  0,128, 78, 80,240,218,127, 64,200,158,127,126,217,139, 87,
/* 0x1450 */  80,224,139,127, 80, 80, 90,127,192,  0,117, 57, 46,235,148,127,
/* 0x1460 */  32,  0,216,123, 32,  0, 74,123,164, 15,124,121, 36,  0,157, 65,
/* 0x1470 */  64, 40,191,127,120,255,190, 65,  0,  0, 95,137, 46, 64, 90, 87,
/* 0x1480 */ 120,211, 74,125, 40, 64,216,123, 32,  0, 74,121,  1,  0,255, 59,
/* 0x1490 */  46,226, 20,124,254,170, 11, 87,214,  1,107,125, 64, 88,138,127,
/* 0x14a0 */  32,  0,122,121,204,  3,156, 64,  7,  0,149, 47,  0,  8, 96, 33,
/* 0x14b0 */ 112, 46,107,125, 38,  0,160,126,254,239,181, 86, 20,  2, 11,124,
/* 0x14c0 */ 208,  0,181,126, 66,240,181,122,  0, 16,181,122, 46,227, 20,124,
/* 0x14d0 */ 104,255,225,249,  3,  0,181, 58,104,  6, 99, 58, 64,200,154,127,
/* 0x14e0 */  36,  0,157, 65, 64, 40,191,127,  4,255,190, 65,  0,  0,127,137,
/* 0x14f0 */  46, 64, 74, 85,120, 83,106,125, 40, 64, 90,123, 32,  0, 74,121,
/* 0x1500 */   1,  0,255, 59,  0,  0, 19,160,254,170, 75, 87,214,  1,107,125,
/* 0x1510 */  64, 88,138,127, 32,  0,126,121, 72,  5,156, 64,  0,  8, 96, 33,
/* 0x1520 */  56, 24,123, 87,112, 46,107,125,180,  7,123,127, 20,  2, 11,124,
/* 0x1530 */   2,  0,123, 59,  0,  0, 96, 57,164, 15,123,123, 80,255, 97,249,
/* 0x1540 */   0,  0, 19,176,  3,  0,128, 57, 20,218,115,126,255,255, 12, 59,
/* 0x1550 */  32,  0, 24,123,  1,  0, 24, 59,166,  3,  9,127,  1,  0,160, 59,
/* 0x1560 */  64,200,158,127, 60,  8,187, 87,164, 15,188,123, 64, 40, 63,127,
/* 0x1570 */ 120,219,125,127, 46, 64, 75, 85,  1,  0,123, 59, 20,226,147,127,
/* 0x1580 */  28,  0,157, 65,104,254,186, 65,  0,  0, 95,137, 40, 64,222,123,
/* 0x1590 */ 120, 91, 74,125, 32,  0, 74,121,  1,  0,255, 59,  0,  0,252,162,
/* 0x15a0 */ 254,170,203, 87,214,185,107,125,  0,  8, 23, 32, 64, 88,138,127,
/* 0x15b0 */ 126,217,250, 86,112, 46,  0,124, 80,184, 90,127, 20,186,  0,124,
/* 0x15c0 */  80,240,203,127, 80, 80,235,126, 32,  0,107,121,164,  3,156, 64,
/* 0x15d0 */   0,  0, 28,176,180,  7,189,127,120, 91,126,125,132,255,  0, 66,
/* 0x15e0 */  80,255, 97,233,  1,  0,  0, 56, 48, 96, 12,124,  3,  0,149, 47,
/* 0x15f0 */  80, 88,140,125, 20,234,140,125, 80,255,129,145,188,  3,157, 65,
/* 0x1600 */   3,  0,140, 47, 32,  0,139,121, 36,  6,157, 65,  6,  0,  0, 56,
/* 0x1610 */  50, 48,107, 85,166,  3,  9,124,180,  7,107,125,176,  1,107, 57,
/* 0x1620 */ 164, 15,119,121,  1,  0,128, 59, 64,200,158,127, 60,  8,155, 87,
/* 0x1630 */ 164, 15,157,123, 64, 40, 63,127,120,219,124,127, 46, 64, 75, 85,
/* 0x1640 */   1,  0,123, 59, 20,186,189,127, 28,  0,157, 65,160,253,186, 65,
/* 0x1650 */   0,  0, 95,137, 40, 64,222,123,120, 91, 74,125, 32,  0, 74,121,
/* 0x1660 */   1,  0,255, 59, 46,234,116,126,254,170,203, 87,214,153,107,125,
/* 0x1670 */   0,  8, 19, 32, 64, 88,138,127,126,217,122, 86,112, 46,  0,124,
/* 0x1680 */  80,152, 90,127, 20,154,  0,124, 80,240,235,125, 80, 80,107,126,
/* 0x1690 */  32,  0,126,121,244,  2,156, 64, 46,235, 20,124,180,  7,156,127,
/* 0x16a0 */ 136,255,  0, 66,192,255,156, 59,  3,  0,156, 47,180,  7,155,127,
/* 0x16b0 */ 240,  2,157, 64, 13,  0,156, 47,254,  7,128, 87,  2,  0,  0, 96,
/* 0x16c0 */ 112, 14,139,127, 32,  0, 29,120,192,  5,157, 65,255,255,107, 57,
/* 0x16d0 */  48, 88, 28,124,176,  2,187, 35, 20,226,189,127,164, 15,189,123,
/* 0x16e0 */ 254,255,189, 59,180,  7,123,125, 20,234,116,125,255,255, 27, 56,
/* 0x16f0 */  32,  0, 29,120,  1,  0,189, 59,  1,  0, 96, 59,  1,  0, 64, 59,
/* 0x1700 */ 166,  3,169,127, 28,  0,  0, 72,  0,  0,184,179,180,  7,123,127,
/* 0x1710 */ 120,  3, 30,124, 60,  8, 90, 87,180,  7, 90,127,136,  2, 64, 66,
/* 0x1720 */  64,200,158,127, 60,  8,119, 87,164, 15,120,123, 64, 40, 63,127,
/* 0x1730 */ 120,187,251,126, 46, 64, 64, 85,120,227, 79,127,  1,  0,247, 58,
/* 0x1740 */  20,194, 11,127, 28,  0,157, 65,164,252,186, 65,  0,  0, 95,137,
/* 0x1750 */  40, 64,222,123,120,  3, 74,125, 32,  0, 74,121,  1,  0,255, 59,
/* 0x1760 */   0,  0,152,161,254,170,192, 87,214, 97,  0,124,  0,  8,172, 35,
/* 0x1770 */  64,  0,138,127,126,217,147, 85,112, 46,189,127, 80, 96,115,126,
/* 0x1780 */  20, 98,189,127, 80,240,192,127, 80, 80,128,125, 32,  0,  0,120,
/* 0x1790 */ 120,255,188, 65,  0,  0,120,178, 32,  0,222,123, 32,  0,138,121,
/* 0x17a0 */ 180,  7,251,126, 32,  0,252,121,108,255,255, 75,  1,  0, 96, 57,
/* 0x17b0 */  20,  0,  0, 72, 46, 91,158,127,180,  7, 11,127,255,  0,139, 47,
/* 0x17c0 */ 136,  0,157, 65, 64,200,128,127, 60,  8,122, 85,120,211, 88,127,
/* 0x17d0 */  64, 40, 63,127, 46, 64, 93, 85,  1,  0, 90, 59,164, 15,107,121,
/* 0x17e0 */  28,  0,157, 65,  8,252,186, 65,  0,  0, 95,137, 40, 64,  0,120,
/* 0x17f0 */ 120,235, 74,125, 32,  0, 74,121,  1,  0,255, 59, 46, 90,254,126,
/* 0x1800 */ 254,170, 29, 84,214,185,189,127,  0,  8,151, 35, 64,232,138,127,
/* 0x1810 */ 126,217,251, 86,112, 46,156,127, 80,184,123,127, 20,186,156,127,
/* 0x1820 */  80,  0,125,126, 80, 80,253,126, 32,  0,160,123,136,255,188, 65,
/* 0x1830 */  46, 91,126,127,180,  7, 75,127,255,  0,139, 47, 32,  0, 96,122,
/* 0x1840 */  32,  0,234,122,128,255,157, 64,  3,  0,149, 47,  1,  0,182, 59,
/* 0x1850 */  32,  6,107,121, 32,  0,189,123,174,177,103,125,120,  3, 30,124,
/* 0x1860 */ 120,235,182,127,116,251,189, 65,  0,  0,160, 58,188,  1,  0, 72,
/* 0x1870 */  80,192, 11,127, 64,200,152,127,126,217, 30, 84, 80,  0, 30,124,
/* 0x1880 */  80, 80,107,125, 46,227, 20,124, 32,  0, 30,123, 32,  0,106,121,
/* 0x1890 */  24,  0, 28, 56, 36,  0,157, 65, 64, 40,191,127, 80,251,190, 65,
/* 0x18a0 */   0,  0, 95,137, 46, 64,107, 85,120, 91, 74,125, 40, 64, 30,123,
/* 0x18b0 */  32,  0, 74,121,  1,  0,255, 59, 46,  2,116,125,254,170,216, 87,
/* 0x18c0 */ 214, 89, 24,127, 64,192,138,127, 32,  0, 26,123, 36,  2,156, 64,
/* 0x18d0 */   0,  8,203, 35, 64,200,152,127,112, 46,222,127, 20, 90,126,125,
/* 0x18e0 */  46,  3,116,125,224,  1,189, 59, 36,  0,157, 65, 64, 40,191,127,
/* 0x18f0 */ 252,250,190, 65,  0,  0,127,137, 46, 64, 74, 85,120, 83,106,125,
/* 0x1900 */  40, 64, 26,123, 32,  0, 74,121,  1,  0,255, 59, 46,234, 20,124,
/* 0x1910 */ 254,170, 75, 87,214,  1,107,125, 64, 88,138,127, 32,  0,126,121,
/* 0x1920 */  20,  3,156, 64,  0,  8, 96, 33,  0,  0,182, 47,112, 46,107,125,
/* 0x1930 */  20,  2,107,125, 46,235,116,125,180,250,190, 65,  7,  0,149, 47,
/* 0x1940 */  80,176,111,125, 32,  0,107,121, 38,  0,160,126,254,239,181, 86,
/* 0x1950 */ 174, 88,103,125,208,  0,181,126,164,  7,181,122,  1,  0, 22, 56,
/* 0x1960 */ 174,177,103,125, 11,  0,181, 58, 32,  0, 22,120,188,  0,  0, 72,
/* 0x1970 */   0,  0, 92,179, 32,  0,222,123, 32,  0,234,122,180,  7,125,127,
/* 0x1980 */ 224,251,  0, 66, 92,252,255, 75, 46,235, 84,127, 32,  0,254,121,
/* 0x1990 */  32,  0,106,122,180,  7,124,127,144,252,  0, 66,  8,253,255, 75,
/* 0x19a0 */  32,  0,156,123,  1,  0,156, 59, 33,  0,143,123,132,  0,130, 65,
/* 0x19b0 */   7,  0,181, 58,180,  7,181,126, 64,176,143,127, 48,250,189, 65,
/* 0x19c0 */  80,255, 97,129,  1,  0,150, 59, 20, 90, 28,124, 80,176,175,127,
/* 0x19d0 */  32,  0,189,123, 80,  0, 15,124, 80,  0, 29,124, 32,  0, 11,120,
/* 0x19e0 */   1,  0,107, 57,120,179,219,126,166,  3,105,125, 20,  0,  0, 72,
/* 0x19f0 */ 120,179,219,126, 32,  0,189,123, 56,  0,157, 64,  1,  0,150, 59,
/* 0x1a00 */ 174,232,103,125, 64,224,136,127,  1,  0,189, 59, 32,  0,150,123,
/* 0x1a10 */ 174,217,103,125,220,255,  0, 66,104,255,  1,232, 96,255,193,249,
/* 0x1a20 */ 166,  2,200,125,166,  3,  8,124, 64,176,136,127, 36,248,157, 65,
/* 0x1a30 */ 255,  0, 64, 61,255,255, 74, 97, 64, 80,158,127, 16,  0,157, 65,
/* 0x1a40 */  64, 40,191,127,168,249,190, 65,  1,  0,255, 59, 80,248,132,124,
/* 0x1a50 */   0,  0,134,144,  0,  0, 96, 56,  0,  0,201,146,148,249,255, 75,
/* 0x1a60 */  80,208, 75,127, 64,200,154,127,126,217, 30, 84, 80, 80,107,125,
/* 0x1a70 */  80,  0, 30,124, 32,  0, 93,123, 32,  0,106,121,  0,  0, 19,176,
/* 0x1a80 */  36,  0,157, 65, 64, 40,191,127,100,249,190, 65,  0,  0, 31,136,
/* 0x1a90 */  46, 64,106, 85,120, 83, 10,124, 40, 64, 93,123, 32,  0, 74,121,
/* 0x1aa0 */   1,  0,255, 59,  2,  0, 19,160,254,170,171, 87,214,  1,107,125,
/* 0x1ab0 */  64, 88,138,127, 32,  0,126,121, 56,  1,156, 64,  0,  8,160, 35,
/* 0x1ac0 */  56, 24,107, 87,180,  7,107,125,112, 46,189,127, 20,  2, 29,124,
/* 0x1ad0 */ 130,  0,107, 57,  2,  0, 19,176,164, 15,107,121,  8,  0,  0, 56,
/* 0x1ae0 */  20, 90,115,126, 80,255,  1,248,  3,  0,128, 57, 96,250,255, 75,
/* 0x1af0 */  80,240,216,127, 64,200,158,127,126,217,125, 85, 80, 88,125,125,
/* 0x1b00 */  80, 80, 24,127, 32,  0,221,123, 32,  0, 10,123, 46,  3,116,125,
/* 0x1b10 */  48,  0,252, 58, 36,  0,157, 65, 64, 40,191,127,208,248,190, 65,
/* 0x1b20 */   0,  0,127,137, 46, 64, 10, 87,120, 83,106,125, 40, 64,221,123,
/* 0x1b30 */  32,  0, 74,121,  1,  0,255, 59, 46,186, 20,124,254,170,171, 87,
/* 0x1b40 */ 214,  1,107,125, 64, 88,138,127, 32,  0,122,121, 24,  1,156, 65,
/* 0x1b50 */  80,232,171,127, 64,200,157,127,126,217, 30, 84, 80,  0, 30,124,
/* 0x1b60 */  80, 80,107,125, 32,  0,190,123, 32,  0,106,121, 46,187, 20,124,
/* 0x1b70 */  72,  0,156, 59, 36,  0,157, 65, 64, 40,191,127,112,248,190, 65,
/* 0x1b80 */   0,  0, 95,137, 46, 64,107, 85,120, 91, 74,125, 40, 64,190,123,
/* 0x1b90 */  32,  0, 74,121,  1,  0,255, 59, 46,226, 20,124,254,170,203, 87,
/* 0x1ba0 */ 214,  1,107,125, 64, 88,138,127, 32,  0,122,121, 80,  1,156, 64,
/* 0x1bb0 */   0,  8, 96, 33,112, 46,107,125, 20,  2, 11,124,104,255,225,249,
/* 0x1bc0 */  46,227, 20,124,120,115,207,125, 96,255,193,233,  7,  0,149, 47,
/* 0x1bd0 */ 108, 10, 99, 58, 38,  0,160,126,254,239,181, 86,208,  0,181,126,
/* 0x1be0 */  66,240,181,122,  0, 16,181,122, 11,  0,181, 58,240,248,255, 75,
/* 0x1bf0 */ 126,217, 30, 84, 80,  0, 30,124, 80, 80, 75,125, 80,232,203,127,
/* 0x1c00 */  16,  0, 96, 57,  2,  0, 19,176, 32,  0, 74,121,  4,  2,115, 58,
/* 0x1c10 */  32,  0,222,123, 80,255, 97,249,  8,  0,128, 57, 48,249,255, 75,
/* 0x1c20 */ 250,255,181, 58,180,  7,181,126,  0,254,255, 75,  3,  0, 96, 57,
/* 0x1c30 */ 220,249,255, 75,126,217, 30, 84, 80,208, 75,127, 80, 80, 75,125,
/* 0x1c40 */  80,  0,126,125,166,  2,  8,124, 32,  0, 90,123,166,  3,200,125,
/* 0x1c50 */ 104,255,  1,248, 32,  0, 74,121, 46,235,116,125, 96,255,193,233,
/* 0x1c60 */ 108,255,255, 75,  0,  8, 96, 33,112, 46,107,125, 20,  2, 11,124,
/* 0x1c70 */ 104,255,225,249, 46,187, 20,124,166,  2,232,125,166,  3,200,125,
/* 0x1c80 */  96,255,193,233, 72,255,255, 75,250,255,107, 57, 32,  0,107,121,
/* 0x1c90 */   1,  0,107, 57,166,  3,105,125, 64,200,158,127, 60,  8,188, 87,
/* 0x1ca0 */  64, 40, 63,127, 46, 64, 64, 85,  1,  0,155, 99, 28,  0,157, 65,
/* 0x1cb0 */  60,247,186, 65,  0,  0, 95,137, 40, 64,222,123,120,  3, 74,125,
/* 0x1cc0 */  32,  0, 74,121,  1,  0,255, 59,126,248,222, 87, 64,240,138,127,
/* 0x1cd0 */  80, 80, 30,124, 32,  0,157,123, 32,  0,222,123, 12,  0,156, 65,
/* 0x1ce0 */  32,  0, 10,120, 32,  0,125,123,176,255,  0, 66, 72,  6, 99, 57,
/* 0x1cf0 */  40, 32,188,123,  4,  0, 96, 59,244,249,255, 75,126,217, 29, 84,
/* 0x1d00 */  80,  0, 29,124, 80,240,203,127, 80, 80, 75,125,104,255,225,249,
/* 0x1d10 */  46,227, 20,124, 32,  0, 74,121, 32,  0,218,123, 96,255,225,233,
/* 0x1d20 */ 172,254,255, 75,  0,  0,192, 58, 36,253,255, 75,  0,  0,  0,  0,
/* 0x1d30 */   0,  0,  0,  1, 48,  0, 33, 56, 24,  0,161,232, 16,  0,225,232,
/* 0x1d40 */   0,  0,165,232,  0,  0, 33,232, 20, 58,165,124, 16,  0,  1,232,
/* 0x1d50 */ 255,255,165, 56,  0,  0, 33,232,166,  3,  8,124, 85, 80, 88, 33,
/* 0x1d60 */ 161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1d70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,102,105,108,101,
/* 0x1d80 */  32,102,111,114,109, 97,116, 32,101,108,102, 54, 52, 45,112,111,
/* 0x1d90 */ 119,101,114,112, 99,108,101, 10, 10, 83,101, 99,116,105,111,110,
/* 0x1da0 */ 115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32,
/* 0x1db0 */  32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86,
/* 0x1dc0 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1dd0 */  32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1de0 */  32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,
/* 0x1df0 */ 110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 76, 73, 78,
/* 0x1e00 */  85, 88, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1e10 */  48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e20 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e30 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52,
/* 0x1e40 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1e50 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1e60 */  76, 89, 10, 32, 32, 49, 32, 76, 73, 78, 85, 88, 48, 49, 48, 32,
/* 0x1e70 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48,
/* 0x1e80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1e90 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ea0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 50, 42, 42,
/* 0x1eb0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x1ec0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50,
/* 0x1ed0 */  32, 76, 73, 78, 85, 88, 48, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1ee0 */  48, 48, 48, 48, 48, 54, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ef0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1f00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1f10 */  48, 48, 48, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1f20 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1f30 */  32, 32, 51, 32, 76, 73, 78, 85, 88, 48, 51, 48, 32, 32, 32, 32,
/* 0x1f40 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1f50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1f60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1f70 */  48, 48, 48, 48, 48, 48, 98, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1f80 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1f90 */  76, 89, 10, 32, 32, 52, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32,
/* 0x1fa0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 49, 56, 32, 32, 48,
/* 0x1fb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1fc0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fd0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 98, 52, 32, 32, 50, 42, 42,
/* 0x1fe0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x1ff0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53,
/* 0x2000 */  32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x2010 */  48, 48, 48, 48, 49, 52, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2020 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2030 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2040 */  48, 48, 49, 99, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2050 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x2060 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 78, 82, 86, 50, 69,
/* 0x2070 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 54,
/* 0x2080 */  56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2090 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20a0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 49, 48, 32,
/* 0x20b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x20c0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x20d0 */  10, 32, 32, 55, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32,
/* 0x20e0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 99, 32, 32, 48, 48, 48,
/* 0x20f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2100 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2110 */  32, 48, 48, 48, 48, 48, 52, 55, 56, 32, 32, 50, 42, 42, 48, 32,
/* 0x2120 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x2130 */  78, 76, 89, 10, 32, 32, 56, 32, 67, 70, 76, 85, 83, 72, 32, 32,
/* 0x2140 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 52, 32, 32,
/* 0x2150 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2160 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2170 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 57, 52, 32, 32, 50, 42,
/* 0x2180 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2190 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 76, 90, 77, 65, 32,
/* 0x21a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x21b0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21c0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21d0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 98, 56, 32,
/* 0x21e0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x21f0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 76, 90,
/* 0x2200 */  77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2210 */  48, 48, 57, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2220 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2230 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52,
/* 0x2240 */  98, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2250 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2260 */  78, 76, 89, 10, 32, 49, 49, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2270 */  49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 98, 98, 56, 32, 32,
/* 0x2280 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2290 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22a0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 53, 52, 99, 32, 32, 50, 42,
/* 0x22b0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x22c0 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 76, 90, 77, 65, 95,
/* 0x22d0 */  68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 99, 51,
/* 0x22e0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22f0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2300 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 49, 48, 52, 32,
/* 0x2310 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2320 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 76, 90,
/* 0x2330 */  77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2340 */  48, 48, 50, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2350 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2360 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,100,
/* 0x2370 */  51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2380 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52,
/* 0x2390 */  32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48,
/* 0x23a0 */  48, 48, 48, 48, 48, 50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x23b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x23c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x23d0 */  48, 49,100, 53, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x23e0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x23f0 */  83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48,
/* 0x2400 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2410 */  32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 50, 48,  9,
/* 0x2420 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2430 */  32, 76, 73, 78, 85, 88, 48, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x2440 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2450 */ 100, 32, 32, 76, 73, 78, 85, 88, 48, 51, 48,  9, 48, 48, 48, 48,
/* 0x2460 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78,
/* 0x2470 */  85, 88, 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2480 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x2490 */  82, 86, 95, 84, 65, 73, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 84, 65, 73,
/* 0x24b0 */  76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24c0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x24d0 */  68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24e0 */  48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x24f0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2500 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88,
/* 0x2510 */  48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2520 */  48, 48, 48, 48, 32, 76, 73, 78, 85, 88, 48, 48, 48, 10, 48, 48,
/* 0x2530 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2540 */  32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 49, 48,  9,
/* 0x2550 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2560 */  32, 76, 73, 78, 85, 88, 48, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x2570 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2580 */ 100, 32, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2590 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 10,
/* 0x25a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x25b0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48,
/* 0x25c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x25d0 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x25e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x25f0 */  82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2600 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x2610 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x2620 */  32, 32,100, 32, 32, 67, 70, 76, 85, 83, 72,  9, 48, 48, 48, 48,
/* 0x2630 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 70, 76,
/* 0x2640 */  85, 83, 72, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2650 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x2660 */  65,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2670 */  48, 48, 32, 76, 90, 77, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2680 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2690 */  32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48,
/* 0x26a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77,
/* 0x26b0 */  65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x26c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x26d0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48,
/* 0x26e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77,
/* 0x26f0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2700 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2710 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48,
/* 0x2720 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77,
/* 0x2730 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2740 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2750 */  32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48,
/* 0x2760 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 85, 80, 88, 49, 72,
/* 0x2770 */  69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2780 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x2790 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x27a0 */  48, 48, 48, 32,102,105,108,116,101,114, 95,108,101,110,103,116,
/* 0x27b0 */ 104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x27c0 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x27d0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x27e0 */  48, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 10, 82, 69,
/* 0x27f0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2800 */  32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 88, 48, 48, 48, 93, 58,
/* 0x2810 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2820 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2830 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2840 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 80, 80, 67,
/* 0x2850 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 76, 73, 78,
/* 0x2860 */  85, 88, 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2870 */  48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x2880 */  69, 76, 50, 52, 32, 32, 32, 32, 32, 76, 73, 78, 85, 88, 48, 50,
/* 0x2890 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x28a0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 88,
/* 0x28b0 */  48, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x28c0 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x28d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x28e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x28f0 */  82, 95, 80, 80, 67, 54, 52, 95, 65, 68, 68, 82, 51, 50, 32, 32,
/* 0x2900 */  32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104, 10,
/* 0x2910 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x2920 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 65, 68, 68, 82, 51, 50, 32,
/* 0x2930 */  32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 10, 82,
/* 0x2940 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x2950 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79,
/* 0x2960 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2970 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2980 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2990 */  48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x29a0 */  95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84,
/* 0x29b0 */  65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x29c0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86,
/* 0x29d0 */  50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x29e0 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x29f0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x2a00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82,
/* 0x2a10 */  95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32,
/* 0x2a20 */  32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67,
/* 0x2a30 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x2a40 */  82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x2a50 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69,
/* 0x2a60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x2a70 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a80 */  48, 48,100, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x2a90 */  49, 52, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10,
/* 0x2aa0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x2ab0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76,
/* 0x2ac0 */  70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x2ad0 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x2ae0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x2af0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x2b00 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32,
/* 0x2b10 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48,
/* 0x2b20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 56, 10
};
