/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser.x3d;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.fastinfoset.EncodingAlgorithm;
import org.jvnet.fastinfoset.EncodingAlgorithmException;

public class ByteEncodingAlgorithm
implements EncodingAlgorithm {
    public static final String ALGORITHM_URI = "http://www.web3d.org/binary/BYTE";
    protected static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    public static final int BYTE_SIZE = 1;

    public final int getPrimtiveLengthFromOctetLength(int n) throws EncodingAlgorithmException {
        if (n % 1 != 0) {
            throw new EncodingAlgorithmException("'length' is not a multiple of 1 bytes correspond to the size of the 'byte' primitive type");
        }
        return n / 1;
    }

    public int getOctetLengthFromPrimitiveLength(int n) {
        return n * 1;
    }

    public final Object decodeFromBytes(byte[] byArray, int n, int n2) throws EncodingAlgorithmException {
        byte[] byArray2 = new byte[this.getPrimtiveLengthFromOctetLength(n2)];
        this.decodeFromBytesToByteArray(byArray2, 0, byArray, n, n2);
        return byArray2;
    }

    public final Object decodeFromInputStream(InputStream inputStream) throws IOException {
        return this.decodeFromInputStreamToByteArray(inputStream);
    }

    public void encodeToOutputStream(Object object, OutputStream outputStream) throws IOException {
        if (!(object instanceof byte[])) {
            throw new IllegalArgumentException("'data' not an instance of byte[]");
        }
        byte[] byArray = (byte[])object;
        this.encodeToOutputStreamFromByteArray(byArray, outputStream);
    }

    public final Object convertFromCharacters(char[] cArray, int n, int n2) {
        final CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        final ArrayList arrayList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(charBuffer, new WordListener(){

            public void word(int n, int n2) {
                String string = ((Object)charBuffer.subSequence(n, n2)).toString();
                arrayList.add(Byte.valueOf(string));
            }
        });
        return this.generateArrayFromList(arrayList);
    }

    public final void convertToCharacters(Object object, StringBuffer stringBuffer) {
        if (!(object instanceof byte[])) {
            throw new IllegalArgumentException("'data' not an instance of byte[]");
        }
        byte[] byArray = (byte[])object;
        this.convertToCharactersFromByteArray(byArray, stringBuffer);
    }

    public final void decodeFromBytesToByteArray(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n3 / 1;
        for (int i = 0; i < n4; ++i) {
            byArray[n++] = byArray2[n2++];
        }
    }

    public final byte[] decodeFromInputStreamToByteArray(InputStream inputStream) throws IOException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        byte[] byArray = new byte[1];
        while (true) {
            int n;
            int n2;
            if ((n2 = inputStream.read(byArray)) != 1) {
                if (n2 == -1) break;
                while (n2 != 1) {
                    n = inputStream.read(byArray, n2, 1 - n2);
                    if (n == -1) {
                        throw new EOFException();
                    }
                    n2 += n;
                }
            }
            n = byArray[0] & 0xFF;
            arrayList.add(new Byte((byte)n));
        }
        return this.generateArrayFromList(arrayList);
    }

    public final void encodeToOutputStreamFromByteArray(byte[] byArray, OutputStream outputStream) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            outputStream.write(by);
        }
    }

    public final void encodeToBytes(Object object, int n, int n2, byte[] byArray, int n3) {
        this.encodeToBytesFromByteArray((byte[])object, n, n2, byArray, n3);
    }

    public final void encodeToBytesFromByteArray(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            byte by = byArray[i];
            byArray2[n3++] = by;
        }
    }

    public final void convertToCharactersFromByteArray(byte[] byArray, StringBuffer stringBuffer) {
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Byte.toString(byArray[i]));
            if (i == byArray.length) continue;
            stringBuffer.append(' ');
        }
    }

    public final byte[] generateArrayFromList(List list) {
        byte[] byArray = new byte[list.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (Byte)list.get(i);
        }
        return byArray;
    }

    public void matchWhiteSpaceDelimnatedWords(CharBuffer charBuffer, WordListener wordListener) {
        Matcher matcher = SPACE_PATTERN.matcher(charBuffer);
        int n = 0;
        while (matcher.find()) {
            int n2 = matcher.start();
            if (n2 != n) {
                wordListener.word(n, n2);
            }
            n = matcher.end();
        }
    }

    public static interface WordListener {
        public void word(int var1, int var2);
    }
}

