#!/usr/bin/perl
#
# by Patrice Neff, based on whereamy by Adnrew McMillan
# released under the GNU GPL version 2
#
# Verson: 0.1 - 13 Jul 2002
#
# This is a user daemon for whereami which watches the
# file /etc/whereiam/iam and executes the actions in
# ~/.whereami.conf
#

use strict;

my $home = $ENV{HOME};
my $basedir = "/etc/whereami";

############################################################
# gather current location information and build the script
# based on user configuration file
############################################################
sub process_location {
  my $last_locations = "";
  my $now_locations = "";
  my %whereiam;
  my %whereiwas;
  my ( $confname, $scriptname ) = @_;

  my ($k, $v);
  my ( $condition, $script_line );
  my $found;

  # get location information
  if ( "" eq "$now_locations" ) {
    # Read where we last were from where we wrote it last time
    open ( NOWLOCN, "< $basedir/iam" ) && do {
      while ( <NOWLOCN> ) {
        chomp;
        $whereiam{$_} = 1;
        $now_locations .= $_ . ",";
      }
      close NOWLOCN;
      chop $now_locations;
    };
  }
  if ( "" eq "$last_locations" ) {
    # Read where we last were from where we wrote it last time
    open ( LASTLOCN, "< $home/.iam" ) && do {
      while ( <LASTLOCN> ) {
        chomp;
        $whereiwas{$_} = 1;
        $last_locations .= $_ . ",";
      }
      close LASTLOCN;
      chop $last_locations;
    };
  }
  # Write file of these locations for next time...
  open ( IAMLOC, "> $home/.iam" ) && do {
    while( my ($k, $v) = each( %whereiam ) ) {
      print "iam: $k\n";
      print IAMLOC "$k\n";
    }
    close IAMLOC;
  };
  print "locs: $last_locations => $now_locations\n";

  open ( WHEREIAM, "> $scriptname" ) or die( "Can't open \"$scriptname\" for output: ");
  open ( LOCN_CONFIG, "< $confname" ) or die( "Can't open \"$confname\" for input: ");
  printf ( WHEREIAM "#!/bin/sh\n[ \"\$DEBUGWHEREAMI\" = \"1\" ] && set -o xtrace\nLASTLOCN=%s\nLOCATION=%s\n\n", $last_locations, $now_locations );
  my $start_with = "+";
  if ( $now_locations eq $last_locations ) {
    return 0;
  }
  while ( <LOCN_CONFIG> ) {
    /^\s*$/ && next;
    /^\s*#/ && next;
    s/^\s+//;
    ($condition, $script_line) = split( /\s+/, $_, 2);
    if ( $start_with eq "=" ) {
      $found = 0;
      while( ($k, $v) = each( %whereiam ) ) {
        next if ( $found );
        $condition  =~ /=$k$/ && do {
          print WHEREIAM "$script_line";
          $found = 1;
        };
      }
    }
    else {
      $found = 0;
      while( ($k, $v) = each( %whereiwas ) ) {
        next if ( $found );
        $condition =~ /-$k$/ && do {
          print WHEREIAM "$script_line";
          $found = 1;
        };
      }
      $found = 0;
      while( ($k, $v) = each( %whereiam ) ) {
        next if ( $found );
        $condition =~ /[+=]$k$/ && do {
          print WHEREIAM "$script_line";
          $found = 1;
        };
      }
    }
  }
  close WHEREIAM;
  close LOCN_CONFIG;
  return 1;
}

while(1) {
  print "waking up\n";
  if(process_location("$home/.whereami.conf", "$home/.whereiam.sh")) {
    system("sh -c \". $home/.whereiam.sh\"");
  }
  sleep(60);
}
