/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;
import org.javia.arity.Symbols;
import org.javia.arity.SyntaxException;

public class GraphWindow
extends JFrame {
    double[] xdata;
    double[] ydata;
    int xpix;
    int ypix;
    double xmax;
    double xmin;
    double ymax;
    double ymin;
    double dy;
    double dx;
    int steps;
    Color bgcolor3 = new Color(164, 235, 60);

    public void plotfunction(String string) {
        Symbols symbols = new Symbols();
        int n = 0;
        this.xmin = -5.0;
        this.xmax = 5.0;
        this.xpix = this.getSize().width;
        this.ypix = this.getSize().height;
        this.dx = this.xmax - this.xmin;
        this.steps = (int)(10.0 * this.dx);
        this.xdata = new double[this.steps + 10];
        this.ydata = new double[this.steps + 10];
        this.ymax = 1.0;
        this.ymin = -1.0;
        for (double d = this.xmin; d < this.xmax; d += 0.1) {
            double d2;
            String string2 = string.replaceAll("x", "(" + d + ")");
            try {
                d2 = symbols.eval(string2);
            }
            catch (SyntaxException syntaxException) {
                d2 = 0.0;
                System.out.println("error " + syntaxException);
            }
            if (d2 > this.ymax) {
                this.ymax = d2;
            }
            if (d2 < this.ymin) {
                this.ymin = d2;
            }
            this.xdata[n] = d * ((double)this.xpix / this.dx) - this.xmin * (double)this.xpix / this.dx;
            this.ydata[n] = d2;
            ++n;
        }
        this.ymax = 1.2 * this.ymax;
        this.ymin = 1.2 * this.ymin;
        this.dy = this.ymax - this.ymin;
        if (this.dy == 0.0) {
            this.dy = 100.0;
        }
        for (n = 0; n < this.steps; ++n) {
            this.ydata[n] = this.ydata[n] * -0.6 * (double)this.ypix / this.dy + 0.6 * (double)this.ypix * this.ymax / this.dy + 0.3 * (double)this.ypix;
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.bgcolor3);
        graphics.fillRect(0, 0, this.xpix, this.ypix);
        graphics.setColor(Color.red);
        for (int i = 0; i < this.steps - 1; ++i) {
            graphics.drawLine((int)this.xdata[i], (int)this.ydata[i], (int)this.xdata[i + 1], (int)this.ydata[i + 1]);
        }
        graphics.setColor(Color.blue);
        graphics.drawLine(0, (int)(0.6 * (double)this.ypix * this.ymax / this.dy + 0.3 * (double)this.ypix), this.xpix, (int)(0.6 * (double)this.ypix * this.ymax / this.dy + 0.3 * (double)this.ypix));
        graphics.drawLine((int)(-1.0 * this.xmin * (double)this.xpix / this.dx), 0, (int)(-1.0 * this.xmin * (double)this.xpix / this.dx), this.ypix);
    }
}

