/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.XmlReader;

public class JvxlXmlReader
extends VolumeFileReader {
    protected String JVXL_VERSION = "2.1";
    protected int surfaceDataCount;
    protected int edgeDataCount;
    protected int colorDataCount;
    private int excludedTriangleCount;
    private int excludedVertexCount;
    protected boolean haveContourData;
    private XmlReader xr;
    protected boolean isXmlFile = true;
    protected boolean thisInside;
    String tempDataXml;
    protected BitSet bsVoxelBitSet;
    private int fractionPtr;
    private String strFractionTemp = "";

    JvxlXmlReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isJvxl = true;
        this.jvxlData.wasJvxl = true;
        this.isXLowToHigh = false;
        this.xr = new XmlReader(bufferedReader);
    }

    protected boolean readVolumeData(boolean bl) {
        if (!super.readVolumeData(bl)) {
            return false;
        }
        this.strFractionTemp = this.jvxlEdgeDataRead;
        this.fractionPtr = 0;
        return true;
    }

    protected boolean gotoAndReadVoxelData(boolean bl) {
        this.initializeVolumetricData();
        if (this.nPointsX < 0 || this.nPointsY < 0 || this.nPointsZ < 0) {
            return true;
        }
        try {
            this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
            if (this.vertexDataOnly) {
                return true;
            }
            this.readSurfaceData(bl);
            if (this.edgeDataCount > 0) {
                this.jvxlEdgeDataRead = this.jvxlReadData("edge", this.edgeDataCount);
            }
            this.jvxlData.jvxlExcluded = new BitSet[4];
            this.params.bsExcluded = this.jvxlData.jvxlExcluded;
            if (this.colorDataCount > 0) {
                this.jvxlColorDataRead = this.jvxlReadData("color", this.colorDataCount);
            }
            if (this.excludedVertexCount > 0) {
                this.jvxlData.jvxlExcluded[0] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedVertexData", null, false));
                if (this.xr.isNext("jvxlExcludedPlaneData")) {
                    this.jvxlData.jvxlExcluded[2] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedPlaneData", null, false));
                }
            }
            if (this.excludedTriangleCount > 0) {
                this.jvxlData.jvxlExcluded[3] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedTriangleData", null, false));
            }
            if (this.haveContourData) {
                this.jvxlDecodeContourData(this.jvxlData, this.xr.getXmlData("jvxlContourData", null, false));
            }
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            return false;
        }
        return true;
    }

    protected void readParameters() throws Exception {
        String string = this.xr.getXmlData("jvxlFileTitle", null, false);
        this.jvxlFileHeaderBuffer = new StringBuffer(string);
        this.xr.toTag("jvxlVolumeData");
        String string2 = this.tempDataXml = this.xr.getXmlData("jvxlVolumeData", null, true);
        this.volumetricOrigin.set(this.xr.getXmlPoint(string2, "origin"));
        this.isAngstroms = true;
        this.readVector(0);
        this.readVector(1);
        this.readVector(2);
        this.line = this.xr.toTag("jvxlSurfaceSet");
        this.nSurfaces = this.parseInt(XmlReader.getXmlAttrib(this.line, "count"));
        Logger.info("jvxl file surfaces: " + this.nSurfaces);
        Logger.info("using default edge fraction base and range");
        Logger.info("using default color fraction base and range");
        this.cJvxlEdgeNaN = (char)(this.edgeFractionBase + this.edgeFractionRange);
    }

    protected void readVector(int n) throws Exception {
        String string = this.xr.getXmlData("jvxlVolumeVector", this.tempDataXml, true);
        this.tempDataXml = this.tempDataXml.substring(this.tempDataXml.indexOf(string) + string.length());
        int n2 = this.parseInt(XmlReader.getXmlAttrib(string, "count"));
        if (n2 == Integer.MIN_VALUE) {
            this.vertexDataOnly = true;
        }
        this.voxelCounts[n] = n2 < 0 ? 0 : n2;
        this.volumetricVectors[n].set(this.xr.getXmlPoint(string, "vector"));
        if (this.isAnisotropic) {
            this.setVectorAnisotropy(this.volumetricVectors[n]);
        }
    }

    protected void gotoData(int n, int n2) throws Exception {
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + n2 + " points each");
        }
        this.jvxlData.vertexDataOnly = n2 == 0;
        this.vertexDataOnly = this.jvxlData.vertexDataOnly;
        for (int i = 0; i < n; ++i) {
            this.jvxlSkipData(n2, true);
        }
        this.xr.toTag("jvxlSurface");
        this.jvxlReadSurfaceInfo();
    }

    protected void jvxlSkipData(int n, boolean bl) throws Exception {
        this.readLine();
        this.xr.skipTag("jvxlSurface");
    }

    protected void jvxlReadSurfaceInfo() throws Exception {
        String string;
        int n;
        String string2 = this.xr.getXmlData("jvxlSurfaceInfo", null, true);
        this.isXLowToHigh = XmlReader.getXmlAttrib(string2, "isXLowToHigh").equals("true");
        this.jvxlCutoff = this.parseFloat(XmlReader.getXmlAttrib(string2, "cutoff"));
        if (!Float.isNaN(this.jvxlCutoff)) {
            Logger.info("JVXL read: cutoff " + this.jvxlCutoff);
        }
        this.haveContourData = (n = this.parseInt(XmlReader.getXmlAttrib(string2, "nContourData"))) > 0;
        this.params.isContoured = XmlReader.getXmlAttrib(string2, "contoured").equals("true");
        if (this.params.isContoured) {
            int n2 = this.parseInt(XmlReader.getXmlAttrib(string2, "nContours"));
            if (n2 <= 0) {
                n2 = 0;
            } else {
                string = XmlReader.getXmlAttrib(string2, "contourValues");
                if (string.length() > 0) {
                    this.params.contoursDiscrete = this.parseFloatArray(string);
                    this.jvxlData.contourValues = this.params.contoursDiscrete;
                    Logger.info("JVXL read: contourValues " + Escape.escapeArray(this.jvxlData.contourValues));
                }
                if ((string = XmlReader.getXmlAttrib(string2, "contourColors")).length() > 0) {
                    this.params.contourColixes = Graphics3D.getColixArray(string);
                    this.jvxlData.contourColixes = this.params.contourColixes;
                    this.jvxlData.contourColors = Graphics3D.getHexCodes(this.jvxlData.contourColixes);
                    Logger.info("JVXL read: contourColixes " + Graphics3D.getHexCodes(this.jvxlData.contourColixes));
                }
                this.params.contourFromZero = XmlReader.getXmlAttrib(string2, "contourFromZero").equals("true");
            }
            this.params.nContours = this.haveContourData ? n : n2;
        }
        this.params.isBicolorMap = XmlReader.getXmlAttrib(string2, "bicolorMap").equals("true");
        if (this.params.isBicolorMap || this.params.colorBySign) {
            this.jvxlCutoff = 0.0f;
        }
        this.jvxlDataIsColorMapped = this.params.isBicolorMap || XmlReader.getXmlAttrib(string2, "colorMapped").equals("true");
        this.jvxlData.isJvxlPrecisionColor = XmlReader.getXmlAttrib(string2, "precisionColor").equals("true");
        this.jvxlData.colorDensity = this.params.colorDensity = XmlReader.getXmlAttrib(string2, "colorDensity").equals("true");
        string = XmlReader.getXmlAttrib(string2, "plane");
        if (string.indexOf("{") >= 0) {
            try {
                this.params.thePlane = (Point4f)Escape.unescapePoint(string);
                Logger.info("JVXL read: plane " + this.params.thePlane);
                if (this.params.scale3d == 0.0f) {
                    this.params.scale3d = this.parseFloat(XmlReader.getXmlAttrib(string2, "scale3d"));
                }
                if (Float.isNaN(this.params.scale3d)) {
                    this.params.scale3d = 0.0f;
                }
            }
            catch (Exception exception) {
                Logger.error("Error reading 4 floats for PLANE definition -- setting to 0 0 1 0  (z=0)");
                this.params.thePlane = new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
            }
            this.surfaceDataCount = 0;
            this.edgeDataCount = 0;
        } else {
            this.params.thePlane = null;
            this.surfaceDataCount = this.parseInt(XmlReader.getXmlAttrib(string2, "nSurfaceInts"));
            this.edgeDataCount = this.parseInt(XmlReader.getXmlAttrib(string2, "nBytesUncompressedEdgeData"));
        }
        this.excludedVertexCount = this.parseInt(XmlReader.getXmlAttrib(string2, "nExcludedVertexes"));
        this.excludedTriangleCount = this.parseInt(XmlReader.getXmlAttrib(string2, "nExcludedTriangles"));
        this.colorDataCount = Math.max(0, this.parseInt(XmlReader.getXmlAttrib(string2, "nBytesUncompressedColorData")));
        boolean bl = this.jvxlDataIs2dContour = this.params.thePlane != null && this.jvxlDataIsColorMapped;
        if (this.jvxlDataIs2dContour) {
            this.params.isContoured = true;
        }
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        boolean bl2 = XmlReader.getXmlAttrib(string2, "insideOut").equals("true");
        float f = Float.NaN;
        float f2 = Float.NaN;
        float f3 = Float.NaN;
        float f4 = Float.NaN;
        if (this.jvxlDataIsColorMapped) {
            f = this.parseFloat(XmlReader.getXmlAttrib(string2, "dataMinimum"));
            f2 = this.parseFloat(XmlReader.getXmlAttrib(string2, "dataMaximum"));
            f3 = this.parseFloat(XmlReader.getXmlAttrib(string2, "valueMappedToRed"));
            f4 = this.parseFloat(XmlReader.getXmlAttrib(string2, "valueMappedToBlue"));
            if (Float.isNaN(f)) {
                f3 = -1.0f;
                f = -1.0f;
                f4 = 1.0f;
                f2 = 1.0f;
            }
        }
        this.jvxlSetColorRanges(f, f2, f3, f4, bl2);
    }

    protected void jvxlSetColorRanges(float f, float f2, float f3, float f4, boolean bl) {
        if (this.jvxlDataIsColorMapped) {
            if (!Float.isNaN(f) && !Float.isNaN(f2)) {
                if (f2 == 0.0f && f == 0.0f) {
                    f = -1.0f;
                    f2 = 1.0f;
                }
                this.params.mappedDataMin = f;
                this.params.mappedDataMax = f2;
                Logger.info("JVXL read: data_min/max " + this.params.mappedDataMin + "/" + this.params.mappedDataMax);
            }
            if (!this.params.rangeDefined) {
                if (!Float.isNaN(f3) && !Float.isNaN(f4)) {
                    if (f3 == 0.0f && f4 == 0.0f) {
                        f3 = -1.0f;
                        f4 = 1.0f;
                    }
                    this.params.valueMappedToRed = f3;
                    this.params.valueMappedToBlue = f4;
                    this.params.rangeDefined = true;
                } else {
                    this.params.valueMappedToRed = 0.0f;
                    this.params.valueMappedToBlue = 1.0f;
                    this.params.rangeDefined = true;
                }
            }
            Logger.info("JVXL read: color red/blue: " + this.params.valueMappedToRed + "/" + this.params.valueMappedToBlue);
        }
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
        this.jvxlData.insideOut = bl;
        if (this.params.insideOut) {
            this.jvxlData.insideOut = !this.jvxlData.insideOut;
        }
        this.params.insideOut = this.jvxlData.insideOut;
    }

    protected void readSurfaceData(boolean bl) throws Exception {
        boolean bl2 = this.thisInside = !this.params.isContoured;
        if (this.readSurfaceData()) {
            return;
        }
        this.tempDataXml = this.xr.getXmlData("jvxlEdgeData", null, true);
        this.bsVoxelBitSet = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlEdgeData", this.tempDataXml, false));
        this.readVolumeFileSurfaceData();
    }

    protected boolean readSurfaceData() throws Exception {
        if (this.vertexDataOnly) {
            this.getEncodedVertexData();
            return true;
        }
        if (this.params.thePlane != null) {
            this.volumeData.setDataDistanceToPlane(this.params.thePlane);
            this.setVolumeData(this.volumeData);
            this.params.cutoff = 0.0f;
            this.jvxlData.setSurfaceInfo(this.params.thePlane, 0, "");
            this.jvxlData.scale3d = this.params.scale3d;
            return true;
        }
        return false;
    }

    protected void readVolumeFileSurfaceData() throws Exception {
        super.readSurfaceData(false);
    }

    protected String jvxlReadData(String string, int n) {
        String string2;
        try {
            if (string.equals("edge")) {
                string2 = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib(this.tempDataXml, "data"));
            } else {
                String string3 = this.xr.getXmlData("jvxlColorData", null, true);
                this.jvxlData.isJvxlPrecisionColor = XmlReader.getXmlAttrib(string3, "encoding").endsWith("2");
                string2 = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib(string3, "data"));
            }
        }
        catch (Exception exception) {
            Logger.error("Error reading " + string + " data " + exception);
            throw new NullPointerException();
        }
        return string2;
    }

    protected BitSet getVoxelBitSet(int n) throws Exception {
        if (this.bsVoxelBitSet != null) {
            return this.bsVoxelBitSet;
        }
        BitSet bitSet = new BitSet();
        if (this.surfaceDataCount <= 0) {
            return bitSet;
        }
        int n2 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = this.parseInt();
            if (n2 == Integer.MIN_VALUE) {
                this.readLine();
                if (this.line == null || (n2 = this.parseInt(this.line)) == Integer.MIN_VALUE) {
                    if (!this.endOfData) {
                        Logger.error("end of file in JvxlReader? line=" + this.line);
                    }
                    this.endOfData = true;
                    n2 = 10000;
                }
            }
            this.thisInside = !this.thisInside;
            ++this.jvxlNSurfaceInts;
            if (!this.thisInside) continue;
            bitSet.set(i, i + n2);
        }
        return bitSet;
    }

    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, Point3f point3f, Vector3f vector3f, float[] fArray, Point3f point3f2) {
        if (this.edgeDataCount <= 0) {
            return super.getSurfacePointAndFraction(f, bl, f2, f3, point3f, vector3f, fArray, point3f2);
        }
        fArray[0] = this.jvxlGetNextFraction(this.edgeFractionBase, this.edgeFractionRange, 0.5f);
        point3f2.scaleAdd(fArray[0], vector3f, point3f);
        return fArray[0];
    }

    private float jvxlGetNextFraction(int n, int n2, float f) {
        if (this.fractionPtr >= this.strFractionTemp.length()) {
            if (!this.endOfData) {
                Logger.error("end of file reading compressed fraction data");
            }
            this.endOfData = true;
            this.strFractionTemp = "" + (char)n;
            this.fractionPtr = 0;
        }
        return JvxlCoder.jvxlFractionFromCharacter(this.strFractionTemp.charAt(this.fractionPtr++), n, n2, f);
    }

    protected String readColorData() {
        this.fractionPtr = 0;
        int n = this.jvxlData.vertexCount = this.meshData.vertexCount;
        short[] sArray = this.meshData.vertexColixes;
        float[] fArray = this.meshData.vertexValues;
        String string = this.strFractionTemp = this.isJvxl ? this.jvxlColorDataRead : "";
        if (this.isJvxl && this.strFractionTemp.length() == 0) {
            Logger.error("You cannot use JVXL data to map onto OTHER data, because it only contains the data for one surface. Use ISOSURFACE \"file.jvxl\" not ISOSURFACE .... MAP \"file.jvxl\".");
            return "";
        }
        this.fractionPtr = 0;
        Logger.info("JVXL reading color data mapped min/max: " + this.params.mappedDataMin + "/" + this.params.mappedDataMax + " for " + n + " vertices." + " using encoding keys " + this.colorFractionBase + " " + this.colorFractionRange);
        Logger.info("mapping red-->blue for " + this.params.valueMappedToRed + " to " + this.params.valueMappedToBlue + " colorPrecision:" + this.jvxlData.isJvxlPrecisionColor);
        float f = this.params.mappedDataMin == Float.MAX_VALUE ? 0.0f : this.params.mappedDataMin;
        float f2 = (this.params.mappedDataMin == Float.MAX_VALUE ? 1.0f : this.params.mappedDataMax) - f;
        float f3 = this.params.valueMappedToBlue - this.params.valueMappedToRed;
        float f4 = Float.MAX_VALUE;
        float f5 = -3.4028235E38f;
        if (sArray == null || sArray.length < n) {
            this.meshData.vertexColixes = sArray = new short[n];
        }
        String string2 = this.jvxlColorDataRead;
        int n2 = 0;
        short s = 0;
        short s2 = 0;
        if (this.params.colorBySign) {
            s2 = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos);
            s = ColorEncoder.getColorIndex(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg);
        }
        int n3 = this.meshData.vertexIncrement;
        for (int i = 0; i < n; i += n3) {
            float f6;
            float f7;
            if (this.jvxlData.isJvxlPrecisionColor) {
                f7 = JvxlCoder.jvxlFractionFromCharacter2(string2.charAt(n2), string2.charAt(n2 + n), this.colorFractionBase, this.colorFractionRange);
                f6 = f + f7 * f2;
            } else {
                f7 = JvxlCoder.jvxlFractionFromCharacter(string2.charAt(n2), this.colorFractionBase, this.colorFractionRange, 0.5f);
                f6 = this.params.valueMappedToRed + f7 * f3;
            }
            fArray[i] = f6;
            ++n2;
            if (f6 < f4) {
                f4 = f6;
            }
            if (f6 > f5) {
                f5 = f6;
            }
            if (this.marchingSquares != null && this.params.isContoured) {
                this.marchingSquares.setContourData(i, f6);
                continue;
            }
            sArray[i] = this.params.colorBySign ? ((this.params.isColorReversed ? f6 > 0.0f : f6 <= 0.0f) ? s : s2) : this.getColorIndexFromPalette(f6);
        }
        if (this.params.mappedDataMin == Float.MAX_VALUE) {
            this.params.mappedDataMin = f4;
            this.params.mappedDataMax = f5;
        }
        return string2 + "\n";
    }

    protected void getEncodedVertexData() throws Exception {
        String string = this.xr.getXmlData("jvxlSurfaceData", null, true);
        String string2 = this.xr.getXmlData("jvxlTriangleData", string, true);
        this.jvxlDecodeVertexData(this.xr.getXmlData("jvxlVertexData", string, true), false);
        String string3 = this.xr.getXmlData("jvxlPolygonColorData", string, false);
        this.jvxlDecodeTriangleData(string2, string3);
        Logger.info("Checking for vertex values");
        string = this.xr.getXmlData("jvxlColorData", string, true);
        this.jvxlData.isJvxlPrecisionColor = XmlReader.getXmlAttrib(string, "encoding").endsWith("2");
        this.jvxlColorDataRead = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib(string, "data"));
        if (this.jvxlColorDataRead.length() == 0) {
            this.jvxlColorDataRead = this.xr.getXmlData("jvxlColorData", string, false);
        }
        boolean bl = this.jvxlDataIsColorMapped = this.jvxlColorDataRead.length() > 0;
        if (this.haveContourData) {
            this.jvxlDecodeContourData(this.jvxlData, this.xr.getXmlData("jvxlContourData", null, false));
        }
    }

    public Point3f[] jvxlDecodeVertexData(String string, boolean bl) throws Exception {
        int n = this.parseInt(XmlReader.getXmlAttrib(string, "count"));
        if (!bl) {
            Logger.info("Reading " + n + " vertices");
        }
        Point3f point3f = this.xr.getXmlPoint(string, "min");
        Point3f point3f2 = this.xr.getXmlPoint(string, "max");
        point3f2.sub(point3f);
        int n2 = this.jvxlData.colorFractionBase;
        int n3 = this.jvxlData.colorFractionRange;
        int n4 = n * 3;
        Point3f[] point3fArray = bl ? new Point3f[n] : null;
        Point3f point3f3 = bl ? null : new Point3f();
        String string2 = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib(string, "data"));
        if (string2.length() == 0) {
            string2 = this.xr.getXmlData("jvxlVertexData", string, false);
        }
        int n5 = -1;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                point3f3 = point3fArray[i] = new Point3f();
            }
            float f = JvxlCoder.jvxlFractionFromCharacter2(string2.charAt(++n5), string2.charAt(n5 + n4), n2, n3);
            point3f3.x = point3f.x + f * point3f2.x;
            f = JvxlCoder.jvxlFractionFromCharacter2(string2.charAt(++n5), string2.charAt(n5 + n4), n2, n3);
            point3f3.y = point3f.y + f * point3f2.y;
            f = JvxlCoder.jvxlFractionFromCharacter2(string2.charAt(++n5), string2.charAt(n5 + n4), n2, n3);
            point3f3.z = point3f.z + f * point3f2.z;
            if (bl) continue;
            this.addVertexCopy(point3f3, 0.0f, i);
        }
        return point3fArray;
    }

    int[][] jvxlDecodeTriangleData(String string, String string2) throws Exception {
        int n = string2 == null ? -1 : 0;
        int n2 = 0;
        int n3 = this.parseInt(XmlReader.getXmlAttrib(string, "count"));
        Logger.info("Reading " + n3 + " triangles");
        int[][] nArray = null;
        int[] nArray2 = new int[3];
        String string3 = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib(string, "data"));
        if (string3.length() == 0) {
            string3 = this.xr.getXmlData("jvxlTriangleData", string, false);
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int n4 = 0;
        int n5 = 0;
        int n6 = 92;
        int n7 = 0;
        int n8 = -1;
        block5: while (n7 < n3) {
            int n9;
            char c = string3.charAt(++n8);
            switch (c) {
                case '!': {
                    n9 = 0;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '+': 
                case ',': 
                case '.': {
                    continue block5;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    nArray3[0] = n8;
                    n9 = Parser.parseInt(string3, nArray3);
                    n8 = nArray3[0] - 1;
                    break;
                }
                default: {
                    n9 = c - n6;
                }
            }
            nArray2[n5] = n4 += n9;
            if (++n5 % 3 != 0) continue;
            ++n7;
            n5 = 0;
            if (n >= 0) {
                if (n == 0) {
                    n = Parser.parseInt(string2, nArray4);
                    n2 = Parser.parseInt(string2, nArray4);
                    if (n2 == Integer.MIN_VALUE) {
                        n = 0;
                        n2 = 0;
                    }
                }
                --n;
            }
            this.addTriangleCheck(nArray2[0], nArray2[1], nArray2[2], 7, 0, false, n2);
        }
        return nArray;
    }

    protected void jvxlDecodeContourData(JvxlData jvxlData, String string) throws Exception {
        Vector vector = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = -1;
        jvxlData.vContours = null;
        if (string == null) {
            return;
        }
        while ((n = string.indexOf("<jvxlContour", n + 1)) >= 0) {
            Vector vector2 = new Vector();
            String string2 = this.xr.getXmlData("jvxlContour", string.substring(n), true);
            float f = this.parseFloat(XmlReader.getXmlAttrib(string2, "value"));
            stringBuffer.append(" ").append(f);
            short s = Graphics3D.getColix(Graphics3D.getArgbFromString(XmlReader.getXmlAttrib(string2, "color")));
            int n2 = Graphics3D.getArgb(s);
            stringBuffer2.append(" ").append(Escape.escapeColor(n2));
            String string3 = JvxlCoder.jvxlUncompressString(XmlReader.getXmlAttrib(string2, "data"));
            BitSet bitSet = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlContour", string2, false));
            int n3 = bitSet.length();
            IsosurfaceMesh.setContourVector(vector2, n3, bitSet, f, s, n2, new StringBuffer(string3));
            vector.add(vector2);
        }
        int n4 = vector.size();
        if (n4 > 0) {
            jvxlData.vContours = new Vector[n4];
        }
        this.params.contourColixes = new short[n4];
        jvxlData.contourColixes = this.params.contourColixes;
        this.params.contoursDiscrete = new float[n4];
        jvxlData.contourValues = this.params.contoursDiscrete;
        for (int i = 0; i < n4; ++i) {
            jvxlData.vContours[i] = (Vector)vector.get(i);
            jvxlData.contourValues[i] = ((Float)jvxlData.vContours[i].get(2)).floatValue();
            jvxlData.contourColixes[i] = ((short[])jvxlData.vContours[i].get(3))[0];
        }
        Logger.info("JVXL read: " + n4 + " discrete contours");
        Logger.info("JVXL read: contour values: " + stringBuffer);
        Logger.info("JVXL read: contour colors: " + stringBuffer2);
        jvxlData.contourColors = Graphics3D.getHexCodes(jvxlData.contourColixes);
    }
}

