/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: xracer-arch.h,v 1.2 2000/01/09 15:26:37 rich Exp $
 */

#ifndef __xracer_arch_h__
#define __xracer_arch_h__

#include <stdlib.h>

extern void xrArchInit (void);

extern void *xrArchCreateSharedMemory (size_t size);
extern int   xrArchDeleteSharedMemory (void *ptr, size_t size);
extern int   xrArchSetCallbackOnChildTerminationSignal (void (*fn) (void));
extern int   xrArchSetCallbackOnUserSignal (void (*fn) (void));
extern int   xrArchCreateChild (void (*entry_point) (void *), void *args);
extern int   xrArchWaitChild (void);
extern int   xrArchSendUserSignal (int pid);
extern void  xrArchRecalculateCurrentTime (void);

#endif /* __xracer_arch_h__ */
