/*  
	Copyright (C) 2006 Salvatore Scarciglia <laas.mono@gmail.com>
	http://laas.altervista.org

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This code is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

using System;
using Gtk;

public class yTMessageBox : Dialog {
	public Entry text;
	
	public yTMessageBox (string title, string question,string explanation,bool yesno,bool withTxt) : base () {
		this.Title = title;
		this.HasSeparator = false;
		this.BorderWidth = 6;
		this.Resizable = false;
		
		HBox h = new HBox ();
		h.BorderWidth = 6;
		h.Spacing = 6;
		
		Image i = new Image ();
		i.SetFromStock (Stock.DialogWarning, IconSize.Dialog);
		i.SetAlignment (0.5F, 0);
		h.PackStart (i, false, false, 0);
		
		VBox v = new VBox ();
		Label l = new Label ("<span weight=\"bold\" size=\"larger\">" +	question + "</span>");
		l.LineWrap = true;
		l.UseMarkup = true;
		l.Selectable = true;
		l.Xalign = 0; l.Yalign = 0;
		v.PackStart (l);

		if(withTxt==true) {
			text = new Entry();
			v.PackEnd(text);
		}
		
		l = new Label (explanation);
		l.LineWrap = true;
		l.Selectable = true;
		l.Xalign = 0; l.Yalign = 0;
		v.PackEnd (l);

		h.PackEnd (v);
		h.ShowAll ();
		this.VBox.Add (h);
		this.Icon = new Gdk.Pixbuf(null,"yTicon.png");
		if(yesno==false){
			this.AddButton(Stock.Ok, ResponseType.Ok);
		}
		else {
			this.AddButton(Stock.Yes, ResponseType.Yes);
			this.AddButton(Stock.No, ResponseType.No);
		}
	}
}