/*  zomghelper, an information extractor for Ogg Vorbis files
    Copyright (C) 2005-2013  Clint Adams

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#ifdef HAVE_VORBIS_VORBISFILE_H
# include <vorbis/vorbisfile.h>
#else
# error install libvorbis-dev
#endif

int main(int argc, char **argv) {
	FILE *f;
	OggVorbis_File vf;
	double k;
	vorbis_comment *com;
	char **soc;

	if (argc!=2)
		exit(1);

	f = fopen(argv[1], "r");
	if (f==NULL)
		exit(2);

	if (ov_test(f, &vf, NULL, 0))
		exit(3);

	if (ov_test_open(&vf))
		exit(4);

	k = ov_time_total(&vf,-1);
	if (k == OV_EINVAL)
		exit(5);

	com = ov_comment(&vf,-1);
	if (com == NULL)
		exit(6);

	printf("ZOMGSECS: %d\n", (int)ceil(k));

	soc = com->user_comments;

	while(*(soc)) {
		printf("%s\n", *soc++);
	}
}
